% Skript newton_diode_1.m in dem der Arbeitspunkt einer Diode mit dem 
% Newton-Verfahren ermittelt wird

clear;
% -------- Parameter der Schaltung
Rs = 100;
ug = 5;
I0 = 10e-9;
VT = 25e-3;

% -------- Newton Rekursionen
ualt = 0;
uneu = ualt - ((ug-ualt)/Rs - I0*(exp(ualt/VT) - 1))/(-1/Rs - I0*exp(ualt/VT)/VT);
m = 1;

while abs(uneu - ualt) > 0.01
    ualt = uneu;
    uneu = ualt - ((ug-ualt)/Rs - I0*(exp(ualt/VT) - 1))/(-1/Rs - I0*exp(ualt/VT)/VT);
    m = m+1;
end;
u = uneu

i = (ug - u)/Rs

% ------- Graphische Lsung
u = 0:0.01:ug;
i = (ug-u)/Rs;
m

id = I0*(exp(u/VT) - 1);
k = find(id < 1.5*ug/Rs);

figure(1);   clf;
plot(u, i, u(k), id(k));
title('Kennlinie der Diode und Arbeitsgerade');
xlabel('u in V');   grid on;

