% Skript mischer_quadr1.m


clear;
% ------ Quadratische Kennlinie
uq = -1:0.01:2;
kq = 0.2;
iq = kq*uq.^2.*(uq > 0);

figure(1);   clf;
plot(uq,iq);
title('Quadratische Kennlinie');
xlabel('V');  grid on;
ylabel('A');

% Reihenwiderstand
R = 0.1e3;
% Eingangssignale des Mischers 
f0 = 10e6;      f1 = 200e6;
ampl0 = 1;      ampl1 = 2;

% ------ Numerische Bestimmung der Spannung uq(t)
T = 1/f1;
dt = T/5;
t = 0:dt:100*T-dt;
nt = length(t);
uq = zeros(1,nt);
iq = uq;

ug0 = ampl0*cos(2*pi*f0*t);
ug1 = ampl1*cos(2*pi*f1*t + pi/3);
Ug0 = ampl0 + ampl1;   % Verschiebung des Arbeitspunktes 

for k = 1:nt
    uq_temp = 0;   % Initialisierung
    for p = 1:10   % Arbeitspunkt Bestimmung (Iterationen)
        iq_temp = (Ug0 + ug1(k) + ug0(k)-uq_temp)/R;
        uq_neu = sqrt(iq_temp/kq);
        if abs(uq_neu-uq_temp) < 0.0001
            uq(k) = uq_neu;
            iq(k) = iq_temp;
            break;
        end;
        uq_temp = uq_neu;
    end;        
end;

figure(2);   clf;
subplot(211), plot(t, uq, t, iq*10);

subplot(212), plot(t, ug0 + ug1 + Ug0);
N = nt;


U01 = fft(uq)/N;
Ug01 = fft(ug0 + ug1)/N;

figure(3);   clf;
subplot(211), plot((0:N/2-1)/(N*dt), 20*log10(abs(U01(1:N/2))));
%subplot(211), plot((0:N/2-1)/(N*dt), abs(U01(1:N/2)));
title('Amplitudenspektrum des Quadrieres');
xlabel('Hz');    grid on;
subplot(212), plot((0:N/2-1)/(N*dt), 20*log10(abs(Ug01(1:N/2))));
title('Amplitudenspektrum der Eingangssignale');
xlabel('Hz');    grid on;