% Skript mischer_getakt1.m in dem ein Mischer mit
% getakter Spannung untersucht wird

clear;
% Reihenwiderstnde
R = 1e3;      Rg = 0.1;
% Eingangssignale des Mischers 
f1 = 20e6;          f2 = 200e6;
%f1 = 20.025e6;      f2 = 200e6;

ampl1 = 0.5;        ampl2 = 0.2;
% ------ Numerische Bestimmung von uR(t) 
T = 1/f2;     dt = T/20;
t = 0:dt:50*T-dt;
nt = length(t);
% Eingangsspannungen
ug1 = ampl1*cos(2*pi*f1*t);
ug2 = sign(ampl2*cos(2*pi*f2*t + pi/3));
ug2 = (sign(ampl2*cos(2*pi*f2*t + pi/3))+1)/2;
% Spannung am R
uR = ug1.*ug2*R/(Rg + R);

figure(1);   clf;
plot(t, uR);
title('Zerhackte Spannung')
xlabel('Zeit in s');   grid on;

N = nt;
% ------- Amplitudenspaktrum ber die FFT
UR = fft(uR)/N;		Ug = fft(ug1 + ug2)/N;

figure(2);   clf;
subplot(211), plot((0:N/2-1)/(N*dt), abs(Ug(1:N/2)));
   title('Amplitudenspektrum der Eingangssignale');
   xlabel('Hz');    grid on;
subplot(212), plot((0:N/2-1)/(N*dt), abs(UR(1:N/2)));
   title('Amplitudenspektrum der Ausgangsspannung');
   xlabel('Hz');    grid on;
figure(3);   clf;
subplot(211), plot((0:N/2-1)/(N*dt), 20*log10(abs(Ug(1:N/2))));
   title('Amplitudenspektrum der Eingangssignale');
   xlabel('Hz');    grid on;     ylabel('dB');
subplot(212), plot((0:N/2-1)/(N*dt), 20*log10(abs(UR(1:N/2))));
   title('Amplitudenspektrum der  Ausgangspannung');
   xlabel('Hz');    grid on;     ylabel('dB');