% Skript mischer_diode1.m in dem ein Mischer mit
% Diode in Reihe mit einem Widerstand
% untersucht wird

clear;
% ------ Kennlinie der Diode
Is = 1e-9;    VT = 25e-3;    n = 1.2;
UD = -1:0.01:0.65;
ID = Is*(exp(UD/(n*VT))-1);
  figure(1);   clf;
   plot(UD,ID);
   title('Kennlinie der Diode');
   xlabel('V');  grid on;
   ylabel('A');
% Reihenwiderstand
R = 0.1e3;     % Rg = 0;
% Eingangssignale des Mischers 
f1 = 20e6;          f2 = 200e6;
ampl1 = 0.1;      ampl2 = 0.2;
% ------ Numerische Bestimmung von uD(t) und iD(t)
T = 1/f2;     dt = T/10;
t = 0:dt:50*T-dt;
nt = length(t);
uD = zeros(1,nt);    iD = uD; % Initialisierungen
ug1 = ampl1*cos(2*pi*f1*t);     ug2 = ampl2*cos(2*pi*f2*t + pi/3);
Ug0 = 0.25;     % ampl0 + ampl1;   % Verschiebung des Arbeitspunktes 
for k = 1:nt
    uD_temp = 0;   % Initialisierung
    for p = 1:10   % Arbeitspunkt Bestimmung (Iterationen)
        iD_temp = (Ug0 + ug1(k) + ug2(k)-uD_temp)/R;
        uD_neu = VT*n*log(iD_temp/Is + 1);
        if abs(uD_neu-uD_temp) < 0.001
            uD(k) = uD_neu;   
            iD(k) = iD_temp;
            break;
        end;
        uD_temp = uD_neu;
    end;        
end;
figure(2);   clf;
subplot(211), plot(t, ug1 + ug2 + Ug0);
   title('Die Eingangsspannungen (mit Verschiebung Ug0)');
   xlabel('Zeit in s');    grid on;
subplot(212), plot(t, uD, t, iD*300);
   title('Spannung uD und Strom iD*300');
   xlabel('Zeit in s');    grid on;

N = nt;
U01 = fft(iD)/N;		Ug01 = fft(ug1 + ug2)/N;

figure(3);   clf;
subplot(211), plot((0:N/2-1)/(N*dt), abs(Ug01(1:N/2)));
   title('Amplitudenspektrum der Eingangssignale');
   xlabel('Hz');    grid on;
subplot(212), plot((0:N/2-1)/(N*dt), abs(U01(1:N/2)));
   title('Amplitudenspektrum der  Diodenspannung');
   xlabel('Hz');    grid on;
figure(4);   clf;
subplot(211), plot((0:N/2-1)/(N*dt), 20*log10(abs(Ug01(1:N/2))));
   title('Amplitudenspektrum der Eingangssignale');
   xlabel('Hz');    grid on;     ylabel('dB');
subplot(212), plot((0:N/2-1)/(N*dt), 20*log10(abs(U01(1:N/2))));
   title('Amplitudenspektrum der  Diodenspannung');
   xlabel('Hz');    grid on;     ylabel('dB');