% Skript induktiv_1.m in dem die Magnetisierungskurve
% eines Induktors mit Kern durch die atan-Funktion
% angenhert wird und die entsprechende Induktivitt
% ermittelt wird

clear;
% ------- Parameter der Induktivitt
L0 =0.02;
aL = 10;

di = 0.01;    i = -2:di:2;
L = L0./(1 + aL*i.^2);   % Induktivitt nach Strom
BNA = L0*atan2(sqrt(aL)*i,1)/sqrt(aL); % Magnetisierungs-
        % kurve

figure(1);
plot(i, L, i, BNA);
title(['Induktivitaet und Magnetisierungskurve (aL = ',...
    num2str(aL),'; L0 = ',num2str(L0),' )']);
xlabel('A');   grid on;