% Skript gleich_li2.m in dem ein DC-DC Wandler
% mit nichtlinearer Induktivitt und Glttungskapazitt
% simuliert wird

clear;
% ----- Parameter der Schaltung
Rg = 0;    R = 10;
L0 = 0.002;    C = 20e-6;
aL = 0.1;     % Parameter der Induktivitt
% aL = 2;     % Parameter der Induktivitt
% ------- Numerisches Integrationsverfahren
f = 20000;    T = 1/f;
dt = T/2000;
t = 0:dt:40*T-dt;
% Anregung
ampl = 10;
ug = ampl*sign(sin(2*pi*f*t-pi/4)) + ampl;
nt = length(t);
% Initialisierungen
iL  = zeros(1,nt);     
uc = iL;
for k = 1:nt-1;
    iL(k+1) = iL(k) + dt*(ug(k)-Rg*iL(k)-uc(k))/(L0/(1+aL*iL(k)^2));
    if iL(k+1) < 0
        iL(k+1) = 0;
    end;
    uc(k+1) = uc(k) + dt*(iL(k+1) - uc(k)/R)/C;
end;
L = L0./(1+aL*iL.^2); % Induktivitt

figure(1);    clf;
subplot(311), plot(t, ug);
title('Eingangsspannung');
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1:3), La(4)*1.2]);

subplot(312), plot(t, iL); 
title(['Strom der Induktivitaet (L0 = ',...
    num2str(L0),'; aL = ',num2str(aL),')']);
xlabel('Zeit in s');   grid on;

subplot(313), plot(t, uc); 
title(['Spannung der Kapazitaet (L0 = ',...
    num2str(L0),'; aL = ',num2str(aL),')']);
xlabel('Zeit in s');   grid on;
