% Skript gleich_li1.m in dem ein DC-DC Wandler
% mit nichtlinearer Induktivitt und ohne Kapazitt
% simuliert wird

clear;
% ----- Parameter der Schaltung
Rg = 0;    R = 10;
L0 = 0.002;   % Induktivitt bei i = 0
aL = 10;      % Parameter der Induktivitt
%aL = 0.1;    % Parameter der Induktivitt
% ------- Numerisches Integrationsverfahren
f = 20000;    T = 1/f;
dt = T/2000;
t = 0:dt:20*T-dt;
% Anregung
ampl = 10;
ug = ampl*sign(sin(2*pi*f*t-pi/4)) + ampl; % Rechteckige Pulse
nt = length(t);
% Initialisierungen
iL  = zeros(1,nt);     
for k = 1:nt-1;
    iL(k+1) = iL(k) + dt*(ug(k)-(Rg + R)*iL(k))/(L0/(1+aL*iL(k)^2));
    if iL(k+1) < 0
          iL(k+1) = 0;
    end;    
end;
L = L0./(1+aL*iL.^2); % Induktivitt

figure(1);    clf;
subplot(211), plot(t, ug);
title('Eingangsspannung');
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1:3), La(4)*1.2]);

subplot(212), plot(t, iL); 
title(['Strom der Induktivitaet (L0 = ',...
    num2str(L0),'; aL = ',num2str(aL),')']);
xlabel('Zeit in s');   grid on;


