% Skript einweg_gleich2_1.m in dem die Simulation mit 
% dem Simulink-Modell einweg_gleich21.mdl initialisiert
% und aufgerufen wird

clear;
% -------- Parameter der Schaltung
Rg = 10;         R = 1000;     L = 0.05;
C = 1e-6;
% Parameter der Diode
Is = 20e-9;      VT = 20e-3;
% Anregung
f = 20000;       T = 1/f;
ampl = 10;
% -------- Aufruf der Simulation
sim('einweg_gleich21', [0, 10*T]);
% t = Zeitschritte der Simulation
% y(:,1) = iD(t)
% y(:,2) = uL(t)
% y(:,3) = uD(t)

figure(1);  clf;
subplot(311), plot(t, y(:,1));
title('Strom der Diode');
La = axis;   axis([La(1), t(end), La(3:4)]);
grid on;
subplot(312), plot(t, y(:,3));
title('Spannung der Diode');
La = axis;   axis([La(1), t(end), La(3:4)]);
grid on;
subplot(313), plot(t, y(:,2));
title('Spannung der Induktivitt');
La = axis;   axis([La(1), t(end), La(3:4)]);
xlabel('Zeit in s');   grid on;
