% Skript einweg_gleich1.m in dem eine
% Einweggleichrichtung mit Glttung durch
% Induktivitt untersucht wird

clear;
% ------ Parameter der Schaltung
Rg = 1;    R = 10;    
E0 = 0.7;  rD = 0.5;  % Parameter der Diode
L = 0.1;
f = 50;     T = 1/f;
ampl = 100;
omega = 2*pi*f;

% ------ Numerische Lsung
dt = T/1000;
t = 0:dt:3*T-dt;
ug = ampl*sin(2*pi*f*t);
nt = length(t);

iL = zeros(1,nt);    uL = iL;
for k = 1:nt-1;
    iL(k+1) = iL(k) + dt*(ug(k) - E0 - iL(k)*(rD + Rg + R))/L;
    if iL(k+1) < 0
        iL(k+1) = 0;
    end;
end;
uL = ug - E0 - iL*(rD + Rg + R);
k = find(iL == 0);
uL(k) = 0;

figure(1);    clf;
plot(t,ug/20, t,uL/20, t,iL);
title('ug/20, uL/20, iL');
xlabel('Zeit in s');  grid on;









