% Skript einweg_gleich1.m in dem eine
% Einweggleichrichtung mit Glttung durch
% Induktivitt untersucht wird

clear;
% ------ Parameter der Schaltung
Rg = 1;    R = 10;
L = 0.2;
f = 50;     T = 1/f;
ampl = 100;
omega = 2*pi*f;

% ------ Analytische Lsung
dt = T/500;
t = 0:dt:T-dt;

ug = ampl*sin(2*pi*f*t);
iLp = (ampl/(sqrt((R+Rg)^2+(omega*L)^2)))*...
        sin(2*pi*f*t - atan2(omega*L,(Rg + R)));
iLh = -iLp(1)*exp(-t*(Rg+R)/L);

iL = iLp + iLh;
k = find(iL < 0);
iL(k) = 0;

figure(1);    clf;
plot(t, ug/20, t,iLp, t,iLh, t,iL);
title('ug/20,   iLp,   iLh,   iL');
xlabel('Zeit in s');  grid on;

% ------- Die Spannung der Induktivitt
uL = -iL*(Rg + R) + ug;
k = find(iL == 0);
uL(k) = 0;

figure(2);    clf;
plot(t, ug/20, t, uL/20, t, iL);
title('ug/20, uL/20, iL');
xlabel('Zeit ins');   grid on;







