% Skript diode_2.m in dem der Arbeitspunkt einer
% einfachen Schaltung mit Diode mit der Newton-
% Raphsche-Methode ermittelt wird

clear;
% ------- Parameter der Diode
VT = 25.e-3;    n = 1.3;
Is = 1e-9;
% ------- Kennlinie der Diode im
% ersten Quadranten
UD = 0:0.01:0.75;
ID = Is*(exp(UD./(n*VT)) - 1);

figure(1);   clf;
plot(UD, ID);

% ------- Parameter der Schaltung
R = 10;     Ug = 20;
IDb = (Ug - UD)./R; % Strom ue?ber die Belastungsgerade
hold on;
plot(UD, IDb);
hold off
title('Kennlinie der Diode und Belastungsgerade')
xlabel('V');   grid on;
ylabel('A');

% ------- Arbeitspunktberechnung mit Newton-Raphson-Methode
UD_alt = 0;
UD_neu = UD_alt - ((Ug-UD_alt)/R - ...
    Is*(exp(UD_alt/(n*VT)) - 1))/(-1/R - Is*exp(UD_alt/(n*VT))/(n*VT));
   % Erste Iteration
   
while abs(UD_neu - UD_alt) > 0.005
    UD_alt = UD_neu;
    UD_neu = UD_alt - ((Ug-UD_alt)/R - ...
        Is*(exp(UD_alt/(n*VT)) - 1))/(-1/R - Is*exp(UD_alt/(n*VT))/(n*VT));
end;
Udiode = UD_neu;
Idiode = (Ug - Udiode)/R;

disp('Spannung UD'), Udiode
disp('Strom ID'), Idiode
