% Skript diode_1.m in dem der Arbeitspunkt einer
% einfachen Schaltung mit Diode durch Iterationen
% ermittelt wird

clear;
% ------- Parameter der Diode
VT = 25.e-3;
n = 1.3;
Is = 1e-9;
% ------- Kennlinie der Diode im
% ersten Quadranten
UD = 0:0.01:0.75;
ID = Is*(exp(UD./(n*VT)) - 1);

figure(1);   clf;
plot(UD, ID);
% ------- Parameter der Schaltung
R = 10;     Ug = 20;
IDb = (Ug - UD)./R; % Strom ber die Belastungsgerade
hold on;
plot(UD, IDb);
hold off
title('Kennlinie der Diode und Belastungsgerade')
xlabel('V');   grid on;
ylabel('A');

% ------- Arbeitspunkt Berechnung ber Iterationen
UD = 0;
k = 1;
while k < 10
    ID = (Ug - UD)/R;
    UD_neu = n*VT*log(ID/Is+1);
    if abs(UD_neu - UD) < 0.001
        UD = UD_neu;
        break
    end;    
    UD = UD_neu;
    k = k+1;
end;
disp('Spannung UD'), UD

