% Skrip wechselrichter_2.m in dem ein Wechselrichter
% simuliert wird

clear;
% -------- Prameter der Schaltung
fm = 500;     % Modulationsfrequenz fuer das PWM-Signal
f = 50;       % Ausgangsfrequenz
L = 20e-3;    % Glaettungsinduktivitaet
Rs = 10;      % Verbraucher Widerstand
Ui = 200;     % Gleichspannung

% -------- Erzeugung des PWM-Signals aus Saegezahn
% Saegezahnsignal
Tfinal = 10/f;       dt = 1e-2/fm;
t = 0:dt:Tfinal-dt;
nt = length(t);

uz = (fm*t - floor(fm*t) - 0.5)*2;   %Saegezahnsignal
us = 0.8*cos(2*pi*t*f);        % Muster Signal 50 Hz
um = sign(uz-us);              % PWM-Signal

nd = nt-fix((3/f)/dt):nt;      % Indizes fuer einen Ausschnitt
figure(1);   clf;
subplot(211), plot(t(nd),uz(nd), t(nd), us(nd));
La = axis;   axis([min(t(nd)), max(t(nd)), La(3:4)*1.1]);
title('Muster 50 Hz und Dreiecksignal');
xlabel('Zeit in s');    grid on;

subplot(212), plot(t(nd), um(nd));
title('PWM-Signal');
xlabel('Zeit in s');    grid on;
La = axis;   axis([min(t(nd)), max(t(nd)), La(3:4)*1.1]);

% ------- Ermittlung des PWM modulierten Signals (Euler-Verfahren)
ui = Ui*um;
ua = zeros(1,nt);      
iL = zeros(1,nt);    % Strom der Induktivitaet (als Zustandsvariable)
iL_temp = iL(1,1);     
ni = 10;    dti = dt/ni;   % Interne Iterationen

for k = 1:nt-1
    for p = 1:ni
      iL_temp = iL_temp + dti*(ui(k) - Rs*iL_temp)/L;
    end;
    iL(1,k+1) = iL_temp;
end;
us = iL*Rs;          % Ausgangssignal

figure(2);    clf;
subplot(211), plot(t(nd), ui(nd));
title('PWM-Eingangsspannung');
xlabel('Zeit in s');    grid on;
La = axis;   axis([min(t(nd)), max(t(nd)), La(3:4)*1.1]);

subplot(212), plot(t(nd), us(nd));
title('Ausgangsspannung mit L-Glaettung');
xlabel('Zeit in s');    grid on;
La = axis;   axis([min(t(nd)), max(t(nd)), La(3:4)*1.1]);

% --------- Amplitudenspektrum der PWM-Eingangsspannung
Ts = dt;
ui_neu = ui.*hamming(nt)';
Upwm = fft(ui_neu)/sum(hamming(nt));   % FFT

fmax = 1000;       % Bereich fr die Darstellung  des Spektrums
nf = fix(fmax*nt*dt);

figure(3);    clf;
plot((0:nf-1)/(nt*Ts), 20*log10(abs(Upwm(1:nf))));
title('Amplitudenspektrum der PWM-Eingangsspannung in dB');
xlabel('Hz'),   grid on;

% --------- Amplitudenspektrum der Ausgangsspannung
us_neu = us.*hamming(nt)';
Us = fft(us_neu)/sum(hamming(nt));   % FFT

figure(4);    clf;
plot((0:nf-1)/(nt*Ts), 20*log10(abs(Us(1:nf))));
title('Amplitudenspektrum der Ausgangsspannung in dB');
xlabel('Hz'),   grid on;

figure(5);    clf;
subplot(211);
plot((0:nf-1)/(nt*Ts), 20*log10(abs(Upwm(1:nf))));
title('Amplitudenspektrum der PWM-Eingangsspannung in dB');
xlabel('Hz'),   grid on;

subplot(212);
plot((0:nf-1)/(nt*Ts), 20*log10(abs(Us(1:nf))));
title('Amplitudenspektrum der Ausgangsspannung in dB');
xlabel('Hz'),   grid on;

% -------- Berechnung des Klirrfaktors der Spannungen
% PWM-Spannung
fmax = 100;       % Bereich fr die Suche der Grundwelle
nf = fix(fmax*nt*dt);
upwm1_ampl = 2*max(abs(Upwm(1:nf)));    % Amplitude der Grundwelle
Upwm1 = upwm1_ampl/sqrt(2)              % Effektivwert der Grundwelle
Upwm_total = sqrt(mean(ui.^2)) 
gu_pwm = Upwm1/Upwm_total
klirr_pwm = sqrt(1-gu_pwm^2)

% Ausgangsspannung (mit Glaettung durch L)
fmax = 100;       % Bereich fr die Suche der Grundwelle
nf = fix(fmax*nt*dt);
us1_ampl = 2*max(abs(Us(1:nf)));    % Amplitude der Grundwelle
Us1 = us1_ampl/sqrt(2)              % Effektivwert der Grundwelle
Us_total = sqrt(mean(us.^2)) 
gu_s = Us1/Us_total
klirr_s = sqrt(1-gu_s^2)