% Skrip wechselrichter_1.m 


clear;

% -------- Prameter der Schaltung
fm = 1000;     % Modulationsfrequenz fuer das PWM-Signal
f = 50;       % Ausgangsfrequenz
L = 20e-3;    % Glaettungsinduktivitaet
Rs = 10;      % Verbraucher Widerstand
Ui = 200;     % Gleichspannung

% -------- Erzeugung des PWM-Signals aus Saegezahn
% Saegezahnsignal
Tfinal = 10/f;       dt = 1e-3/fm;
t = 0:dt:Tfinal-dt;
nt = length(t);

uc = cos(2*pi*fm*t);            % Erzeugung des Dreiecksignal
uz = (acos(uc)/(2*pi)-0.25)*4;  % Dreiecksignal

us = 0.8*cos(2*pi*t*f);        % Muster Signal 50 Hz
um = sign(uz-us);               % PWM-Signal

nd = nt-fix((3/f)/dt):nt;            % Indizes fuer einen Ausschnitt

figure(1);   clf;
subplot(211), plot(t(nd),uz(nd), t(nd), us(nd));
La = axis;   axis([min(t(nd)), max(t(nd)), La(3:4)*1.1]);
title('Muster 50 Hz und Dreiecksignal');
xlabel('Zeit in s');    grid on;

subplot(212), plot(t(nd), um(nd));
title('PWM-Signal');
xlabel('Zeit in s');    grid on;
La = axis;   axis([min(t(nd)), max(t(nd)), La(3:4)*1.1]);

% ------- Filterung des PWM-Signals mit Euler-Verfahren
ui = Ui*um;

ua = zeros(1,nt);      iL = zeros(1,nt);
iL_temp = iL(1,1);

for k = 1:nt-1
    iL_temp = iL_temp + dt*(ui(k) - Rs*iL_temp)/L;
    iL(1,k+1) = iL_temp;
end;
us = iL*Rs;    % Ausgangssignal

figure(2);    clf;
subplot(211), plot(t(nd), ui(nd));
title('PWM-Eingangsspannung');
xlabel('Zeit in s');    grid on;
La = axis;   axis([min(t(nd)), max(t(nd)), La(3:4)*1.1]);

subplot(212), plot(t(nd), us(nd));
title('Ausgangsspannung mit L-Glaettung');
xlabel('Zeit in s');    grid on;
La = axis;   axis([min(t(nd)), max(t(nd)), La(3:4)*1.1]);

% --------- Amplitudenspektrum des PWM-Signals
decim = 100;
Ts = dt*decim;
nord = 500;

htp = fir1(nord, 1/decim);  % Dezimierungsfilter
um = filter(htp,1,um);      % Filterung vor der Dezimierung

um_neu = um(1:decim:end);   % Dezimierung
nu = length(um_neu);
um_neu = um_neu.*hamming(nu)';

Um = fft(um_neu)/sum(hanning(nu));   % FFT

figure(3);    clf;
plot((0:nu-1)/(nu*Ts), 20*log10(abs(Um)));
title('Amplitudenspektrum des PWM-Signals in dB');
xlabel('Hz'),   grid on;


% --------- Amplitudenspektrum des Ausgangssignals
us = filter(htp,1,us);      % Filterung vor der Dezimierung

us_neu = us(1:decim:end);   % Dezimierung
nu = length(us_neu);
us_neu = us_neu.*hamming(nu)';

Us = fft(us_neu)/sum(hanning(nu));   % FFT

figure(4);    clf;
plot((0:nu-1)/(nu*Ts), 20*log10(abs(Us)));
title('Amplitudenspektrum des Ausgangssignals in dB');
xlabel('Hz'),   grid on;






