% Skript saugkr_1.m in dem Saugkreise fr die 
% Oberwellen eines Umrichters untersucht werden

clear;

% ------- Rechteckige Spannung des Umrichters
f = 50;     % 50 Hz
T = 1/f;
N = 2000;
Ts = 5*T/N;
fs = 1/Ts;
ampl = 200;

t = 0:Ts:5*T-Ts;
ug = ampl*sign(sin(2*pi*f*t));

% ------- DFT der Spannung
Ug = fft(ug);

% ------- bertragungsstrecke
LN = 0.01;      RN = 20;
L = 0.05;       L3= L;       L5 = L;

C3 = 1/(((2*pi*3*f)^2)*L3);
C5 = 1/(((2*pi*5*f)^2)*L5);
R3 = 1;         R5 = 1;

% ------- bertragungsfunktion
omega = 2*pi*(0:N/2)*fs/N;
YN = 1./(RN + j*omega*LN);
Y5 = 1./(R5 + 1./(j*omega*C5) + j*omega*L5);
Y3 = 1./(R3 + 1./(j*omega*C3) + j*omega*L3);
H = 1./(1+(YN + Y5 + Y3).*(j*omega*L));  % Kontinuierlicher 
                     % Frequenzgang
Hd = [H, conj(H(N/2:-1:2))];  % Symmetrie der DFT fr reelle Systeme
UN = Hd.*Ug;   % DFT des Ausgangs

uN = real(ifft(UN));  % Ausgang berechnet aus der DFT
%###########################################
figure(1);   clf;
subplot(211), plot(t, ug);
title('Eingangssignal')
xlabel('Zeit in s'); grid on;
La = axis;  axis([La(1:2), 1.2*La(3:4)]);

subplot(212), plot(t, uN);
title('Ausgangssignal (mit DFT berechnet)');
xlabel('Zeit in s');    grid on;

figure(2);   clf;
plot((0:N/20-1)*fs/N, 20 * log10(abs(Hd(1:N/20))));
title('Amplitudengang UN/Ug');
xlabel('Hz');           grid on;


% --------- Numerisch mit Euler-Verfahren integriert
dt = Ts/20;
t = 0:dt:10*T-Ts;
ug = ampl*sign(sin(2*pi*f*t));
nt = length(t);
% Initialisierungen
iL  = zeros(1,nt);     iL3 = zeros(1,nt);
iL5 = zeros(1,nt);     iLN = zeros(1,nt);
uC3 = zeros(1,nt);     uC5 = zeros(1,nt);
uN =  zeros(1,nt);     

for k = 1:nt-1;
    uN(k) = (ug(k)+L*RN*iLN(k)/LN+L*R5*iL5(k)/L5+L*R3*iL3(k)/L3...
        +L*uC5(k)/L5+L*uC3(k)/L3)/(1+L/LN+L/L5+L/L3);
    iLN(k+1) = iLN(k) + dt*(uN(k) - iLN(k)*RN)/LN;
    iL5(k+1) = iL5(k) + dt*(uN(k) - iL5(k)*R5 - uC5(k))/L5;
    iL3(k+1) = iL3(k) + dt*(uN(k) - iL3(k)*R3 - uC3(k))/L3;
    uC3(k+1) = uC3(k) + dt*iL3(k)/C3;
    uC5(k+1) = uC5(k) + dt*iL5(k)/C5;    
    iL(k+1) = iL3(k+1) + iL5(k+1) + iLN(k+1);
end;

figure(3);   clf;
subplot(211), plot(t, uN);
title('Ausgangsspannung uN(t) (numerisch integriert)');
xlabel('Zeit in s');   grid on;

subplot(212), plot(t, iL, t, iLN);
title('Strom iL(t) und iLN(t) (numerisch integriert)');
xlabel('Zeit in s');   grid on;

    



