% Skript rekonstruktion_harm1.m in dem eine Pulsfolge 
% mit begrenzter Anzahl von Harmonischen rekonstruiert wird

clear;

% ------- Parameter der Pulsfolge
h = 1;          % Pulshhe
T = 1;          % Periode
tast = 0.5;     % Relative Dauer 
tau = tast*T;   % Dauer der Pulse

% ------- Komplexe Koeffizienten der Fourier-Reihe
nk = 5;         % Bereich der komplexen Koeffizienten 
      % und Anzahl der Harmonischen
n = -nk:nk;
% Komplexe Koeffizienten
cn = ((h*tau)/T)*exp(-j*n*pi*tau/T).*sinc(n*tau/T);

% ------- Rekonstruiertes Signal
dt = 0.001;
t = 0:dt:2*T;
nt = length(t);

y = zeros(1, nt);
for m = 0:2*nk
    y = y + cn(m+1).*exp(j*(m-nk)*2*pi*t/T);
end;
y = real(y);    % Die kleinen Imaginrteile = 0

%#############################
figure(1);    clf;
subplot(211); plot(t, y);
title(['Rekonstruiertes Signal mit nh = ',num2str(nk),...
    ' Harmonischen']);
xlabel('t/T');   grid on;


% ------- Komplexe Koeffizienten der Fourier-Reihe
nk = 20;         % Bereich der komplexen Koeffizienten
      % und Anzahl der Harmonischen
n = -nk:nk;
% Komplexe Koeffizienten
cn = ((h*tau)/T)*exp(-j*n*pi*tau/T).*sinc(n*tau/T);

% ------- Rekonstruiertes Signal
dt = 0.001;
t = 0:dt:2*T;
nt = length(t);

y = zeros(1, nt);
for m = 0:2*nk
    y = y + cn(m+1).*exp(j*(m-nk)*2*pi*t/T);
end;
y = real(y);    % Die kleinen Imaginrteile = 0
    
subplot(212); plot(t, y);
title(['Rekonstruiertes Signal mit nh = ',num2str(nk),...
    ' Harmonischen']);
xlabel('t/T');   grid on;



