% Skript kont2disk_1.m in dem die kontinuierliche
% und diskrete Fourier-Reihe untersucht wird

clear;

% ------ Kontinuierliche bertragungsfunktion 
% erster Ordnung

fp = 100;    % Durchlassfrequenz
omega_p = 2*pi*fp;

% ------ Frequenzgang
fs = 1000;   % Abtastfrequenz
Ts = 1/fs;

N = 200;     % Anzahl der Abtastwerte
f = 0:fs/N:fs*(N-1)/N;  % Frequenzbereich
omega = 2*pi*f; 

Hk = 1./(j*omega/omega_p +1);  % Kontinuierliche
         % bertragungsfunktion 

% ------ Diskretisierung
Hn = [Hk(1:N/2+1), conj(Hk(N/2:-1:2))]; 

% ------ Darstellung Hk, Hn
figure(1);   clf;
subplot(211), plot(f, abs(Hk));
hold on;
stem((0:N-1)*fs/N, abs(Hn));
hold off;
grid on;
title(['Amplitudengang der kontinuierlichen',...
    'und diskreten Uebertragungsfunktion']);

subplot(212), plot(f, angle(Hk));
hold on;
stem((0:N-1)*fs/N, angle(Hn));
hold off;
grid on;
title(['Phasengang der kontinuierlichen',...
    'und diskreten Uebertragungsfunktion']);

% ------- bertragung zweier Harmonischen
% die das Abtasttheorem erfllen und kein Leakage
% ergeben
f1 = 50;     T1 = 1/f1;
f2 = 200;    T2 = 1/f2;
ampl1 = 5;   ampl2 = 10;
% Berechnung des kontinuierlichen Ausgang
t = 0:Ts/10:(N-1)*Ts;
x = ampl1*cos(2*pi*f1*t) + ampl2*cos(2*pi*f2*t + pi/3);

y = ampl1*abs(1/(j*2*pi*f1/omega_p + 1))*cos(2*pi*f1*t + ...
    angle(1/(j*2*pi*f1/omega_p + 1)))+...
    ampl2*abs(1/(j*2*pi*f2/omega_p + 1))*cos(2*pi*f2*t + pi/3 + ...
    angle(1/(j*2*pi*f1/omega_p + 1)));

% Berechnung ber die diskreten Werte
td = 0:Ts:(N-1)*Ts;     % N Abtastwerte (gerade Zahl)
xd = ampl1*cos(2*pi*f1*td) + ampl2*cos(2*pi*f2*td + pi/3);
Xn = fft(xd);   % DFT Eingang
Yn = Xn.*Hn;    % DFT Ausgang
yd = real(ifft(Yn));   % inverse DFT
phix = angle(Xn);    phiy = angle(Yn);

for k = 1:N     % Entfernung der Phasenfehler
    if abs(real(Xn(k))) < 1e-8 & abs(imag(Xn(k))) < 1e-8
        phix(k) = 0;
    end;
    if abs(real(Yn(k))) < 1e-8 & abs(imag(Yn(k))) < 1e-8
        phiy(k) = 0;
    end;    
end;    
% Darstellung der DFTs
figure(2);    clf;
subplot(221), stem((0:N-1)*fs/N, abs(Xn)/N);
title('Betrag der DFT Xn/N');
xlabel('Hz');    grid on;

subplot(223), stem((0:N-1)*fs/N, phix);
title('Winkel der DFT Xn');
xlabel('Hz');    grid on;

subplot(222), stem((0:N-1)*fs/N, abs(Yn)/N);
title('Betrag der DFT Yn/N');
xlabel('Hz');    grid on;

subplot(224), stem((0:N-1)*fs/N, phiy);
title('Winkel der DFT Yn');
xlabel('Hz');    grid on;

% Darstellung der Zeitvariablen
figure(3);    clf;
subplot(211), plot(t, x, t, y);
title('Kontinuierlicher Eingang und Ausgang');
xlabel('Zeit in s');   grid on;

subplot(212), plot(td, xd, td, yd);
title('Diskreter Eingang und Ausgang als kontinuierliche Funktionen');
xlabel('Zeit in s');   grid on;
