% Skript kenngr_2.m in dem das Amplitudenspektrum
% eines symmetrischen Sgezahn ermittelt wird

clear;
% -------- Sgezahnerzeugung
np = 10;      % Anzahl Perioden (Ganze Zahl)
N = 500;      % Anzahl Abtastwerte
T = N/np;     % Periode des Signals
f = 1/T;      % Frequenz des Signals

x = cos(2*pi*(0:N-1)*np/N);  % Cosinusfrmiges Signal
x = (acos(x)/(2*pi)-0.25)*4; % Sgezahn
N = length(x);  % Lnge des Signals

figure(1);    clf;
plot(0:N-1, x);
title('Signal');
xlabel('Index Abtastwerte');   grid on;
axis tight

% -------- DFT des Signals 
X = fft(x)/N;   
figure(2);    clf;
subplot(211), stem((0:N-1)/N, 2*abs(X));
title('Amplitudenspektrum (2.abs(DFT)/N)');
xlabel('Relative Frequenz f/fs');  grid on;

subplot(212), stem((0:N/2-1)/N, 2*abs(X(1:N/2)));
title('Amplitudenspektrum (2.abs(DFT)/N)');
xlabel('Relative Frequenz f/fs');  grid on;

