% Skript kenngr_1.m in dem einige Lenngren
% eines Sgezahnsignal ermittelt und mit den
% idealen Werten verglichen


clear;
% -------- Sgezahnerzeigung
np = 10;      % Ganze Zahl
na = 100;     % Abstand Spitze zu Spitze

Ts = 2;       % Abtastperiode
% Ts = 0.1;       % Abtastperiode
x = mod(0:Ts:np*(na+Ts)-Ts, na+Ts);  % Unipolares Signal
x = x - na/2; % Bipolares Signal ohne Gleichanteil

N = length(x);  % Lnge des Signals

figure(1);    clf;
plot(0:N-1, x);
title('Signal');
xlabel('Index Abtastwerte');   grid on;
axis tight
% -------- DFT des Signals 
X = fft(x)/N;   

figure(2);    clf;
subplot(211), stem((0:N-1)/N, 2*abs(X));
title('Amplitudenspektrum (2.abs(DFT)/N)');
xlabel('Relative Frequenz f/fs');  grid on;

subplot(212), stem((0:N/2-1)/N, 2*abs(X(1:N/2)));
title('Amplitudenspektrum (2.abs(DFT)/N)');
xlabel('Relative Frequenz f/fs');  grid on;

% -------- Effektivwert aus der DFT
xeff_dft = 0.5*sqrt(sum((2*abs(X)).^2))

% -------- Effektivwert aus dem Signal
xeff_time = sqrt(mean(x.^2))

% -------- Idealer Effektivwert
xeff_ideal = (na/2)/sqrt(3)

% -------- Effektivwert der Grundschwingung

X1_dft = sqrt(2)*abs(X(np+1))    % Aus der DFT

X1_ideal = sqrt(2)*(na/2)/pi     % Aus Tabelle

% -------- Klirrfaktor
% Aus der DFT
kl_dft = 0.5*sqrt(sum((2*abs(X(np+2:N-(np+2)))).^2))/xeff_dft

% Idealer Klirrfaktor
kl_ideal = 0.6262