% Skript fourier_pulsfolge1.m in dem die Fourier-Zerlegung
% einer Pulsfolge der periode T und Pulsdauer tau
% ausgehend von der komplexen Form ermittelt wird

clear;

% ------- Parameter der Pulsfolge
h = 1;          % Puslhhe
T = 0.1;        % Periode
tast = 0.1;     % Relative Dauer 
tau = tast*T;   % Dauer der Pulse

% ------- Komplexe Koeffizienten der Fourier-Reihe
nk = 30;        % bereich der komplexen Koeffizienten
n = -nk:nk;
% Komplexe Koeffizienten
cn = ((h*tau)/T)*exp(-j*n*pi*tau/T).*sinc(n*tau/T);

%##################################
figure(1);   clf;
subplot(211), stem(n, abs(cn));
title('Betrag der komplexen Koeffizienten');
xlabel('Index n der Koeffizienten');
grid on;

subplot(212), stem(n, angle(cn));
title('Winkel der komplexen Koeffizienten');
xlabel('Index n der Koeffizienten');
grid on;

% ------- Amplituden und Nullphasen der harmonischen
An = [cn(nk+1), 2*abs(cn(nk+2:end))];  % Ampl. der Harmonischen
phin = angle(cn(nk+1:end));            % Nullphasen

figure(2);   clf;
subplot(211), stem(0:nk, An);
title('Amplituden der Harmonischen');
xlabel('Index der Harmonischen');    grid on;


subplot(212), stem(0:nk, phin);
title('Nullphasen der Harmonischen');
xlabel('Index der Harmonischen');    grid on;