% Skript fourier_2weggleich1.m in dem die Fourier-Reihe
% fr eine gleichgerichtete Sinuskurve (Zweiweggleichrichtung)

clear;
% ------- Parameter
f = 1;      T = 1/f;       omega = 2*pi*f;
dt = T/1000;               t = 0:dt:T-dt;
nt = length(t);
h = 1;                     % Amplitude 
nh = 5;                    % Anzahl der harmonischen

% ------- Amplituden der Harmonischen
n = 2:2:nh*2;
A_0 = 2*h/pi;              % Mittelwert
A_n = zeros(nh,1);         % Initialisierungen
for k = 1:nh
    A_n(k) = 4*h/(pi*(n(k)-1)*(n(k)+1));
end;    

% ------- Nullphasenlagen
phi_0 = 0;                 % Wegen positiven Mittelwert
phi_n = ones(nh,1)*pi;

% ------- Harmonische und ihre Summe
y(1,:) = ones(1, nt)*A_0;
for k = 1:nh
    y(k+1,:) = A_n(k)*cos(omega*n(k)*t + phi_n(k));
end;

figure(1);    clf;
subplot(211), plot(t, y');
xlabel('t/T');   grid on;
title(['Die ersten ',num2str(nh),...
    ' Harmonische An plus Mittelwert A0']);

subplot(212), plot(t, sum(y)')
xlabel('t/T');   grid on;
title('Summe der Harmonischen');

figure(2);    clf;
stem([0,n], 20*log10([A_0, A_n']/A_0), 'Linewidth',2);
title(' Amplitudenspektrum  An/A0 in dB');
ylabel('20 * log10(An / A0)')
xlabel('Index der Harmonischen');  grid on