% Skript dimmer_2.m in dem ein Dimmer mit resistiven
% und mit induktiven Verbraucher untersucht wird 

clear;
% -------- Parameter der Schaltung fr resistive Belastung
f = 50;          % Frequenz
Rs = 100;        % Resistiver Verbraucher
Ug = 230;        % Effektivwert der Spannung

% -------- Erzeugung der Steuerspannung
Tfinal = 10/f;
dt = 0.5e-2/f;
t = 0:dt:Tfinal;        nt = length(t);

phi = pi/3;             % Phasenanschnittwert (Steuerungs
                        % Versptung)
ug0 = cos(2*pi*f*t);    % Netzspannung (Muster)
ug1 = sign(cos(2*pi*f*t));
ug2 = sign(cos(2*pi*f*t - phi));
ust = (ug1 + ug2)/2;    % Steuerspannung

figure(1);     clf;
subplot(211), plot(t, ug0, t, ust);
title('Muster der Netzspannung und Steuerspannung');
xlabel('Zeit in s');    grid on;
La = axis;    axis([La(1:2), 1.1*La(3:4)]);

% ------- Strom des resistiven Verbrauchers
us = ug0*Ug*sqrt(2).*abs(ust);
is = us/Rs;

subplot(212), plot(t, is);
title('Strom des resistiven Verbrauchers');
xlabel('Zeit in s');    grid on;

% --------- Amplitudenspektrum des Stroms
Ts = dt;
is = is.*hamming(nt)';

Is = fft(is)/sum(hamming(nt));   % FFT
fmax = 1000;     
nf = fix(fmax*nt*dt);

figure(2);    clf;
plot((0:nf-1)/(nt*Ts), 20*log10(abs(Is(1:nf))));
title('Amplitudenspektrum des Stroms (resistive Belastung)');
xlabel('Hz'),   grid on;

% -------- Wirkleistung
Pw = mean((is.^2)*Rs)

%################################################
% ------- Strom bei induktiven Verbraucher
Ls = 500e-3;      % Induktivitaet des Verbrauchers
Rs = 100;         % Widerstand des verbrauchers

% ------- Integration mit Euler-Verfahren
iL = zeros(1, nt);
iL_temp = iL(1,1);
ni = 10;          % Interne Iterationen, die nicht 
dti = dt/ni;      % gespeichert werden

for k = 1:nt-1
    for p = 1:ni
      iL_temp = iL_temp + dti*(us(k) - iL_temp*Rs)/Ls;
    end;  
    iL(k+1) = iL_temp;
end;

figure(3);     clf;
subplot(211), plot(t, us);
title('Eingangsspannung');
xlabel('Zeit in s');    grid on;
La = axis;    axis([La(1:2), 1.1*La(3:4)]);

subplot(212), plot(t, iL, t, us/100);
title('Strom des induktiven Verbrauchers und Eingangspannung/100');
xlabel('Zeit in s');    grid on;

% --------- Amplitudenspektrum des Stroms
iLf = iL.*hamming(nt)';
IL = fft(iLf)/sum(hamming(nt));   % FFT

figure(4);    clf;
plot((0:nf-1)/(nt*Ts), 20*log10(abs(IL(1:nf))));
title('Amplitudenspektrum des Stroms (induktive Belastung)');
xlabel('Hz'),   grid on;

% -------- Wirkleistung
PwL = Rs*mean(iL.^2)

% -------- Amplitude der Grundwelle des Stroms
fmax = 100;
nf = fix(fmax*nt*dt);
IL1 = max(abs(IL(1:nf)));
iL1_ampl = 2*IL1;             % Amplitude der Grundwelle
IL_effek = iL1_ampl/sqrt(2)   % Effektivwert

% -------- Wirkleistung der Grundwelle
Pw1L = Rs*(IL_effek^2)

% -------- Blindleistung fr die sinusfrmige Grundwelle
Qw1L = 2*pi*f*Ls*(IL_effek^2)



