% Skript dimmer_1.m in dem ein Dimmer mit resistiven
% und mit induktiven Verbraucher untersucht wird 

clear;

% -------- Parameter der Schaltung
f = 50;
Rs = 200;
Ug = 230;

% -------- Erzeugung der Steuerspannung
Tfinal = 8/f;
dt = 1e-3/f;
t = 0:dt:Tfinal;        nt = length(t);

phi = pi/2;             % Phasenanschnittwert

ug0 = cos(2*pi*f*t);    % Netzspannung (Muster)
ug1 = sign(cos(2*pi*f*t));
ug2 = sign(cos(2*pi*f*t - phi));
ust = (ug1 + ug2)/2;

figure(1);     clf;
subplot(211), plot(t, ug0, t, ust);
title('Netzspannung und Steuerspannung');
xlabel('Zeit in s');    grid on;
La = axis;    axis([La(1:2), 1.1*La(3:4)]);

% ------- Strom des resistiven Verbrauchers
us = ug0*Ug*sqrt(2).*abs(ust);
is = us/Rs;

subplot(212), plot(t, is);
title('Strom des resistiven Verbrauchers');
xlabel('Zeit in s');    grid on;

% --------- Amplitudenspektrum des Stroms
decim = 20;
Ts = dt*decim;
nord = 200;

htp = fir1(nord, 1/decim);  % Dezimierungsfilter
isd = filter(htp,1,is);      % Filterung vor der Dezimierung

is_neu = isd(1:decim:end);   % Dezimierung
nu = length(is_neu);
is_neu = is_neu.*hamming(nu)';

Is = fft(is_neu)/sum(hanning(nu));   % FFT

figure(2);    clf;
plot((0:nu-1)/(nu*Ts), 20*log10(abs(Is)));
title('Amplitudenspektrum des Strom (resistive Belastung)');
xlabel('Hz'),   grid on;


% ------- Strom in induktiven Verbraucher
Ls = 200e-3;
Rs = 50;

% ------- Integration mit Euler-Verfahren
iL = zeros(1, nt);
iL_temp = iL(1,1);

for k = 1:nt-1
    iL_temp = iL_temp + dt*(us(k) - iL_temp*Rs)/Ls;
    iL(k+1) = iL_temp;
end;

figure(3);     clf;
subplot(211), plot(t, us);
title('Eingangsspannung');
xlabel('Zeit in s');    grid on;
La = axis;    axis([La(1:2), 1.1*La(3:4)]);

subplot(212), plot(t, iL);
title('Strom des induktiven Verbrauchers');
xlabel('Zeit in s');    grid on;

% --------- Amplitudenspektrum des Stroms
iLd = filter(htp,1,iL);      % Filterung vor der Dezimierung

iL_neu = iLd(1:decim:end);   % Dezimierung
nu = length(iL_neu);
iL_neu = iL_neu.*hamming(nu)';

IL = fft(iL_neu)/sum(hanning(nu));   % FFT

figure(4);    clf;
plot((0:nu-1)/(nu*Ts), 20*log10(abs(IL)));
title('Amplitudenspektrum des Strom (induktive Belastung)');
xlabel('Hz'),   grid on;












