% Skript dft_5.m in dem die Koeffizienten der komplexen Form
% der Fourier-Reihe einer Einweggleichrichtung ber die DFT
% ermittelt werden
% Das Untersuchungsintervall beinhaltet mehrere Perioden

clear;
% ------- Parameter des Signals
ampl = 10;    % Hhe der Pulse
f = 50;       % Frequenz
T = 1/f;      % Periode 
mp = 10.4;    % Anzahl Perioden im Untersuchungsintervall
t = 0:T/1000:mp*T-T/1000; 

% Diskretisierung
Np = 20;
Ts = T/Np;    fs = 1/Ts;
td = 0:Ts:mp*T-Ts;
N = length(td);

x =  0.5*ampl*(sign(sin(2*pi*f*t))+1).*sin(2*pi*f*t);
xd = 0.5*ampl*(sign(sin(2*pi*f*td))+1).*sin(2*pi*f*td);

flag = 0;
flag = 1;
Np = N;
if flag == 1
    x = x.*hanning(length(x))';
    xd = xd.*hanning(length(xd))';
    Np = sum(hanning(length(xd)));
end;    

Xn = fft(xd);      % DFT der Periode
N = length(xd);
phin = angle(Xn);
for k = 1:N       % Eliminieren der numerischen Fehler 
    if abs(real(Xn(k))) < 1e-8 & abs(imag(Xn(k))) < 1e-8
        phin(k) = 0;
    end;    
end;

% ------- Korrekte Werte aus Tabelle (bis zur 10. Harmonischen)
h = ampl;
cn = 0.5*[2*h/pi, h/2, (2*h/pi)*[1/3, 0, 1/(3*5), 0, 1/(5*7), 0,...
    1/(7*9),0, 1/(9*11)]];
phicn = [0 -pi/2, -pi*[1,0,1,0,1,0,1,0,1]];

%---------------------------------------------
figure(1);   clf;
subplot(311), stem(0:length(xd)-1, xd);
title('Diskretisiertes Signal eines Untersuchungsintervalls');
xlabel('Indizes der Abtastwerte'); grid on;


subplot(312), stem((0:length(Xn)/2-1)*fs/N, abs(Xn(1:N/2))/Np,'r');
title('Betrag cn und Betrag Xn/N');
xlabel('Frequenz in Hz');    grid on;
hold on;
stem(round(mp)*(0:length(cn)-1)*fs/N, cn, 'Linewidth', 1.5);
hold off;
legend('|Xn|','|cn|')

subplot(313), stem((0:length(Xn)/2-1)*fs/N, phin(1:N/2),'r');
title('Winkel cn und Xn');
xlabel('Frequenz in Hz');    grid on;
hold on;
stem(round(mp)*(0:length(phicn)-1)*fs/N, phicn, 'Linewidth', 1.5);
hold off;
legend('Winkel(Xn)','Winkel(cn)')

% ------- Fehler der Betrge
dbetrag = cn - abs(Xn((0:round(mp):round(mp)*length(cn)-1)+1)/Np)
dphase = phicn - phin((0:round(mp):round(mp)*length(cn)-1)+1)




