% Skript dft_4.m in dem die Koeffizienten der komplexen Form
% der Fourier-Reihe einer Einweggleichrichtung ber die DFT
% ermittelt werden

clear;
% ------- Parameter des Signals
ampl = 10;    % Hhe der Pulse
f = 50;       % Frequenz
T = 1/f;      % Periode 
t = 0:T/1000:T-T/1000; 

% Diskretisierung
N = 50;
Ts = T/N;    fs = 1/Ts;
td = 0:Ts:T-Ts;

x = 0.5*ampl*(sign(sin(2*pi*f*t))+1).*sin(2*pi*f*t);
xd = 0.5*ampl*(sign(sin(2*pi*f*td))+1).*sin(2*pi*f*td);

Xn = fft(xd);      % DFT der Periode
phin = angle(Xn);
for k = 1:N       % Eliminieren der numerischen Fehler 
    if abs(real(Xn(k))) < 1e-8 & abs(imag(Xn(k))) < 1e-8
        phin(k) = 0;
    end;    
end;

% ------- Korrekte Werte aus Tabelle (bis zur 10. Harmonischen)
h = ampl;
cn = 0.5*[2*h/pi, h/2, (2*h/pi)*[1/3, 0, 1/(3*5), 0, 1/(5*7), 0,...
    1/(7*9),0, 1/(9*11)]];
phicn = [0 -pi/2, -pi*[1,0,1,0,1,0,1,0,1]];

%---------------------------------------------
figure(1);   clf;
subplot(311), stem(0:length(xd)-1, xd);
title('Diskretisiertes Signal einer Periode');
xlabel('Indizes der Abtastwerte'); grid on;


subplot(312), stem((0:length(Xn)/2-1), abs(Xn(1:N/2))/N,'r');
title('Betrag cn und Betrag Xn/N');
xlabel('Index n (0:N/2)');    grid on;
hold on;
stem((0:length(cn)-1)+0.2, cn, 'Linewidth', 1.5);
hold off;
legend('|Xn|','|cn|')

subplot(313), stem((0:length(Xn)/2-1), phin(1:N/2),'r');
title('Winkel cn und Xn');
xlabel('Index n (0:N/2)');    grid on;
hold on;
stem((0:length(phicn)-1)+0.2, phicn, 'Linewidth', 1.5);
hold off;
legend('Winkel(Xn)','Winkel(cn)')

% ------- Fehler der Betrge
dbetrag = cn - abs(Xn(1:length(cn))/N)
dphase = phicn - phin(1:length(cn))




