% Skript dft_3.m in dem die Koeffizienten der komplexen Form
% der Fourier-Reihe eines periodischen, pulsfrmigen Signals
% mit den Werten der Annherung ber die DFT verglichen werden

clear;
% ------- Parameter des Signals
h = 10;    % Hhe der Pulse
T = 1;     % Periode 1 Sekunde
tau = 0.1; % Pulsdauer

% ------- Koeffizienten der komplexen Form
n = 0:1:10*T/tau;    % Bereich der Indizes der Harmonischen
cn = (h*tau/T)*exp(-j*n*pi*tau/T).*sinc(n*tau/T);

% ------- Die Annherung ber die DFT
N = max(n);     % Anzahl der Bins der DFT
Ts = T/N;         % Abtastperiode
np = round(tau/Ts);  % Anzahl Werte gleich h

x = h*[ones(1, np), zeros(1, N-np)];   % Diskretisiertes
                         % Signal eines Periode
Xn = fft(x);      % DFT der Periode
%---------------------------------------------
figure(1);   clf;
subplot(211), stem(n, abs(cn), 'LineWidth', 2);
hold on;
stem(0:length(Xn)-1, abs(Xn)/N,'r');
title('Betraege von cn und Xn/N');
xlabel('Index n');    grid on;
legend('|cn|', '|Xn|')

subplot(212), stem(n, unwrap(angle(cn)), 'LineWidth', 2);
hold on;
stem(0:length(Xn)-1, unwrap(angle(Xn)),'r');
title('Winkeln von cn und Xn');
xlabel('Index n');    grid on;
legend('Winkeln cn', 'Winkeln Xn')




