% Skript dft_1.m in dem die DFT fr zwei periodische
% Signale eingesetzt wird

clear;

% ------- Parameter der Signale
%f1 = 100;     f2 = 1300;  % Frequenzen in Hz
f1 = 100;     f2 = 330;  % Frequenzen in Hz
fs = 1000;   % Abtastfrequenz

T1 = 1/f1;   % Periode des Signals 1
Ts = 1/fs;   % Abtastperiode

t = 0:T1/1000:5*T1-T1/1000;   % Untersuchungsintervall 
td = 0:Ts:5*T1-Ts;          % bestehend aus 5 Perioden T1
N = length(td);             % Anzahl Abtastwerte

m1 = f1*N/fs               % Index Signal 1
m2 = mod(f2*N/fs,N)        % Index Signal 2

ampl1 = 5;     ampl2 = 10;  % Amplituden
phi1 = pi/3;   phi2 = pi/4; % Nullphasenlagen

% ------ Die Signale
x1 = ampl1*cos(2*pi*f1*t + phi1);   % Kontinuierliche Signals
x2 = ampl2*cos(2*pi*f2*t + phi2);

x1d = ampl1*cos(2*pi*f1*td + phi1); % Zeitdiskrete Signale
x2d = ampl2*cos(2*pi*f2*td + phi2);

figure(1);    clf;
subplot(2,1,1), plot(t, x1);
hold on;
stem(td, x1d);
hold off;
title(['Kontinuierliches und diskretisiertes Signal 1, f1 = ',...
    num2str(f1),' Hz']);
xlabel('Zeit in s');    grid on;

subplot(2,1,2), plot(t, x2);
hold on;
stem(td, x2d);
hold off;
title(['Kontinuierliches und diskretisiertes Signal 2, f2 = ',...
    num2str(f2),' Hz']);
xlabel('Zeit in s');    grid on;

% ------- DFT des ersten Signals
X1 = fft(x1d);
phi1 = angle(X1);
for k = 1:N       % Eliminieren der numerischen Fehler 
    if abs(real(X1(k))) < 1e-8 & abs(imag(X1(k))) < 1e-8
        phi1(k) = 0;
    end;    
end;

figure(2);    clf;
subplot(2,2,1), stem(0:N-1, abs(X1)/N);
title(['Betrag der DFT (Signal 1, f1 = ',num2str(f1),'  Hz)']);
xlabel('Index DFT');   grid on;
ylabel('Betrag(DFT)/N');

subplot(2,2,3), stem(0:N-1, phi1);
title('Winkel der DFT (Signal 1)');
xlabel('Index DFT');   grid on;
ylabel('Winkel der DFT in Rad');

% ------- DFT des zweiten Signals
X2 = fft(x2d);
phi2 = angle(X2);
for k = 1:N       % Eliminieren der numerischen Fehler
    if abs(real(X2(k))) < 1e-8 & abs(imag(X2(k))) < 1e-8
        phi2(k) = 0;
    end;    
end;

subplot(2,2,2), stem(0:N-1, abs(X2)/N);
title(['Betrag der DFT (Signal 2, f2 = ',num2str(f2),'  Hz)']);
xlabel('Index DFT');   grid on;
ylabel('Betrag(DFT)/N');

subplot(2,2,4), stem(0:N-1, phi2);
title('Winkel der DFT (Signal 2)');
xlabel('Index DFT');   grid on;
ylabel('Winkel der DFT in Rad');

% ------- DFT der Summe der zwei Signale
xd = x1d + x2d;

X = fft(xd);
N = length(X);

phi = angle(X);
for k = 1:N
    if abs(real(X(k))) < 1e-8 & abs(imag(X(k))) < 1e-8
        phi(k) = 0;
    end;    
end;

figure(3);    clf;
subplot(2,2,1), stem(0:N-1, abs(X)/N);
title(['Betrag der DFT (f1 = ',num2str(f1),...
    '  Hz; f2 = ',num2str(f2),'  Hz)']);
xlabel('Index DFT');   grid on;
ylabel('Betrag(DFT)/N');

subplot(2,2,3), stem(0:N-1, phi);
title('Winkel der DFT');
xlabel('Index DFT');   grid on;
ylabel('Winkel der DFT in Rad');

% -------- DFT der Summe mit Frequenzen in der Abszisse
%figure(4);    clf;
subplot(2,2,2), stem((0:N-1)*fs/N, abs(X)/N);
title(['Betrag der DFT (f1 = ',num2str(f1),...
    '  Hz; f2 = ',num2str(f2),'  Hz)']);
xlabel('Frequenz in Hz');   grid on;
ylabel('Betrag(DFT)/N');

subplot(2,2,4), stem((0:N-1)*fs/N, phi);
title('Winkel der DFT');
xlabel('Frequenz in Hz');   grid on;
ylabel('Winkel der DFT in Rad');



