% Skript musik_anlage1.m in dem der Frequenzgang einer Musikanlage
% ermittelt und dargestellt wird

%clear;
syms s

% ------- Parameter des Systems
f1 = 10;
T1 = 1/(2*pi*f1);

f2 = 20000;
T2 = 1/(2*pi*f2);
zeta = 0.4;

A0 = 100;

% ------- Uebertragungsfunktion
H1 = A0*s*T1/(s*T1 + 1);
H2 = 1/((T2*s)^2 + 2*zeta*T2*s +1);
H = H1*H2;

f = logspace(0,5,100);
omega = 2*pi*f;

Hr = subs(H, s, j*omega);

figure(1);
subplot(211), semilogx(f, 20*log10(abs(Hr)));
title('Amplitudengang');
xlabel('Hz');      ylabel('dB');
grid on;

subplot(212), semilogx(f, angle(Hr)*180/pi);
title('Phasengang');
xlabel('Hz');      ylabel('Grad');
grid on;

% ------- Sprungantwort
[b, a] = numden(H);
b = sym2poly(b);     a = sym2poly(a);
br = double(b);             ar = double(a);
musik_an = tf(br,ar);

figure(2);
subplot(211);
step(musik_an,0.0005);
title('Sprungantwort (Anfangsantwort)');
xlabel('Zeit in s');   grid on;

subplot(212);
step(musik_an,0.01);
title('Sprungantwort (das Abklingen fuer    t\rightarrow \infty)');
xlabel('Zeit in s');   grid on;
