% Skript freq_annaeher2.m in dem die Frequenzgaenge
% analoger Systeme mit Geraden angenaehert werden

clear;
%###########################################
% -------- Hochpasscharakter 1. Ordnung
f0 = 100;
a1 = floor(log10(f0/100));
a2 = ceil(log10(f0*100));
f = logspace(a1, a2, 500);

omega = 2*pi*f;
H1 = (j*omega/(2*pi*f0))./(j*omega/(2*pi*f0) + 1);
n1 = length(H1);

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(abs(H1)));
title(['Amplitudengang des System 1. Ordnung (f0 = ',num2str(f0), ' Hz)']);
xlabel('Hz');     ylabel('dB');
grid on;

hold on;
flog = log10(f);
Han = 0*(flog>= log10(f0)) + ...
       (20*(flog-log10(f0))).*(flog < log10(f0));
semilogx(f, Han,'r');
hold off;

subplot(212), semilogx(f, angle(H1)*180/pi);
title('Phasengang');
xlabel('Hz');     ylabel('Grad');
grid on;

hold on;    % Die Annaeherung
phi = 0*(flog > log10(f0*10)) + ...
       (90 - (90/2)*(flog-log10(f0/10))).*((flog > log10(f0/10))&(flog <= log10(f0*10))) + ...
       90*(flog <= log10(f0/10));
semilogx(f, phi,'r');
hold off;
%###########################################
% -------- Tiefpasscharakter 2. Ordnung
f0 = 100;
a1 = floor(log10(f0/100));
a2 = ceil(log10(f0*100));
f = logspace(a1, a2, 500);
zeta = 0.2;

omega = 2*pi*f;
H2 = (((j*omega)/(2*pi*f0)).^2)./(((j*omega)/(2*pi*f0)).^2 + j*omega*2*zeta/(2*pi*f0) + 1);
n2 = length(H2);

figure(2);    clf;
subplot(211), semilogx(f, 20*log10(abs(H2)));
title(['Amplitudengang des System 2. Ordnung (f0 = ',num2str(f0), ' Hz, zeta = ',...
    num2str(zeta),')']);
xlabel('Hz');     ylabel('dB');
grid on;

hold on;
flog = log10(f);
Han = 0*(flog > log10(f0)) + ...
       (40*(flog-log10(f0))).*(flog <= log10(f0));
semilogx(f, Han,'r');
hold off;

subplot(212), semilogx(f, angle(H2)*180/pi);
title('Phasengang');
xlabel('Hz');     ylabel('Grad');
grid on;

hold on;    % Die Annaeherung
flog = log10(f);
phi = 180*(flog<= log10(f0/10)) + ...
       (180 - (180/2)*(flog-log10(f0/10))).*((flog > log10(f0/10))&(flog <= log10(f0*10))) + ...
       0*(flog > log10(f0*10));
semilogx(f, phi,'r');
hold off;
%###########################################
% -------- Tiefpasscharakter 2. Ordnung mit zwei 
% charakteristischen Frequenzen 
f01 = 100;
f02 = 20000;
a1 = floor(log10(f01/100));
a2 = ceil(log10(f02*100));
f = logspace(a1, a2, 500);

omega = 2*pi*f;
H21 = (j*omega/(2*pi*f01))./(j*omega/(2*pi*f01) + 1);
H22 = (j*omega/(2*pi*f02))./(j*omega/(2*pi*f02) + 1);

H2 = H21.*H22;
n2 = length(H2);

figure(3);    clf;
subplot(211), semilogx(f, 20*log10(abs(H2)));
title(['Amplitudengang des System 2. Ordnung (f01 = ',num2str(f01), ' Hz,  ', ...
    'f02 = ',num2str(f02), ' Hz)']);
xlabel('Hz');     ylabel('dB');
grid on;

hold on;
flog = log10(f);
Han1 = 0*(flog >= log10(f01)) + ...
       (20*(flog-log10(f01))).*(flog < log10(f01));
Han2 = 0*(flog >= log10(f02)) + ...
       (20*(flog-log10(f02))).*(flog < log10(f02));
Han = Han1 + Han2; 
semilogx(f, Han,'r');
hold off;

subplot(212), semilogx(f, angle(H2)*180/pi);
title('Phasengang');
xlabel('Hz');     ylabel('Grad');
grid on;

hold on;    % Die Annaeherung
flog = log10(f);
phi1 = 90*(flog<= log10(f01/10)) + ...
       (90 - (90/2)*(flog-log10(f01/10))).*((flog > log10(f01/10))&(flog <= log10(f01*10))) - ...
       0*(flog > log10(f01*10));
phi2 = 90*(flog<= log10(f02/10)) + ...
       (90 - (90/2)*(flog-log10(f02/10))).*((flog > log10(f02/10))&(flog <= log10(f02*10))) - ...
       0*(flog > log10(f02*10));
   
semilogx(f, phi1+phi2,'r');
hold off;
