% Skript freq_RC1.m in dem der Frequenzgang eines 
% einfachen RC-Glied berechnet und dargestellt
% wird

clear;
% ------- Parameter der Schaltung
R = 10000;
C = 1e-9;

Tc = R*C;      % Zeitkonstante
omega_c = 1/Tc
fc = omega_c/(2*pi);     % Charakteristische Frequenz


%############################################
% ------- Ausgang am Kondensator
% ------- Komplexer Frequenzgang in linearen Koordinaten
f = linspace(0, 5*fc, 500);   % Lineare Frequenzschritte
% zwischen 0 und 5*fc
omega = 2*pi*f;

H = 1./(j*omega*R*C + 1);
A = abs(H);     phi = angle(H);

figure(1);    clf;
subplot(211), plot(f, A);
title('Amplitudengang in linearen Koordinaten');
xlabel('Frequenz in Hz');    grid on;
hold on;     La = axis;
plot([fc, fc],[La(3), La(4)],'r');
hold off;

subplot(212), plot(f, phi*180/pi);
title('Phasengang in linearen Koordinaten');
xlabel('Frequenz in Hz');    grid on;    ylabel('Grad');
hold on;     La = axis;
plot([fc, fc],[La(3), La(4)],'r');
hold off;

%############################################
% ------- Komplexer Frequenzgang in logarithmischen Koordinaten
a1 = round(log10(fc/100));
a2 = round(log10(fc*100));
f = logspace(a1, a2, 500);   % Logarithmische Frequenzschritte
% zwischen 10^a1 und 10^a2
omega = 2*pi*f;

% ------- Komplexer Frequenzgang
H = 1./(j*omega*R*C + 1);
A = abs(H);     phi = angle(H);

figure(2);    clf;
subplot(211), semilogx(f, A);
title('Amplitudengang mit logarithmischer Abszisse ');
xlabel('Frequenz in Hz');    grid on;
hold on;     La = axis;
plot([fc, fc],[La(3), La(4)],'r');
hold off;

subplot(212), semilogx(f, phi*180/pi);
title('Phasengang mit logarithmischer Abszisse ');
xlabel('Frequenz in Hz');    grid on;    ylabel('Grad');
hold on;     La = axis;
plot([fc, fc],[La(3), La(4)],'r');
hold off;

figure(3);    clf;
subplot(211), semilogx(f, 20*log10(A));
title('Amplitudengang mit logarithmischen Achsen ');
xlabel('Frequenz in Hz');    grid on;
La = axis;    ylabel('dB');
hold on;     
plot([fc, fc],[La(3), La(4)],'r');
hold off;

subplot(212), semilogx(f, phi*180/pi);
title('Phasengang mit logarithmischer Abszisse ');
xlabel('Frequenz in Hz');    grid on;    ylabel('Grad');
hold on;     La = axis;
plot([fc, fc],[La(3), La(4)],'r');
hold off;





