function [x, t] = ellipt_5;
% Funktion ellipt_5.m in dem ein passives elliptisches TP-Filter 
% aus ''Design of Analog Filters'' Rolf Schauman, Mac E. Van
% Valkenburg Seit 340 untersucht wird. 

global ampl fsig nord A B

% ------- Parameter der Schaltung
% Normierte Parameter
Rg = 1;            Rs = 1;
L1 = 0.5822;       L2 = 1.3629;
L3 = 0.5794;

L12 = 0.0032;      L23 = 0.0085;
C1 = 1.1658;       C2 = 1.1569;

f3dB = 1e6;
omega_3dB = 2*pi*f3dB;
Rg = 100;       Rs = Rg;

Lr = Rg/omega_3dB;      % Faktoren f?r die absoluten
Cr = 1/(Rg*omega_3dB);  % Komponenten

% ------- Absolute Werte der Komponenten 
L1 = L1*Lr;       L2 = L2*Lr;
L3 = L3*Lr;

C1 = C1*Cr;       C2 = C2*Cr;
L12 = L12*Lr;     L23 = L23*Lr;

% Frequenzbereich
fc = f3dB; 
a1 = round(log10(fc/100)); 
a2 = round(log10(fc*100)); 
f = logspace(a1, a2, 1000);  % Logarithmische Frequenzschritte
omega = 2*pi*f;

% ------- Bestimmung der Zustandsgleichung in Matrixform
A1 = [0 0 0 C1 0; 0 0 0 0 C2; 0 L23 -(L23+L3) 0 0;...
    L12 -(L12+L2) -L3 0 0; L1 L2 L3 0 0];
B1 = [1 -1 0 0 0; 0 1 -1 0 0; 0 0 Rs 0 -1; 0 0 Rs -1 0;...
    -Rg 0 -Rs 0 0];
B2 = [0 0 0 0 1]';
iA = inv(A1);
A = iA*B1;    B = iA*B2;
C = [0 0 Rs 0 0];   D = 0;

my_sys = ss(A,B,C,D);
[b,a] = ss2tf(A,B,C,D,1);

% -------- Darstellung des Frequenzgangs des
% Zustandsmodells
Hg = freqs(b,a,omega);
figure(1);    clf;
subplot(211), semilogx(f, 20*log10(abs(Hg)));
title('Amplitudengang des identifizierten TP-Filters');
xlabel('Hz'); grid on;
subplot(212), semilogx(f, angle(Hg));
title('Phasengang des identifizierten TP-Filters');
xlabel('Hz'); grid on;% ------- Sprungantwort

% -------- Antwort des Filters auf rechteckigem Signal
% ber die MATLAB-Funktion lsim
fsig = 0.3*f3dB;
ampl = 2;
dt = 0.01/fsig;
Tfinal = 10/fsig;
t = 0:dt:Tfinal;

ue = ampl*sign(cos(2*pi*t*fsig));
ua = lsim(my_sys, ue, t);

figure(2);    clf;
plot(t,ue, t, ua);
La = axis;   axis([0,Tfinal, La(3:4)*1.1]);
title('Anregung und Antwort des Filters (lsim-Funktion)');
xlabel('Zeit in s');   grid on;


% -------- Antwort des Filters auf rechteckigem Signal
% ber Euler-Verfahren
nt = length(t);
nord = 5;
x = zeros(nord,nt);
x_temp = x(:,1);
nint = 100;
dti = dt/nint;

for k = 1:nt-1
    for p = 1:nint
        x_temp = x_temp + dti*(A*x_temp + B*ue(k));
    end;    
    x(:,k+1) = x_temp;
end;    

ua_euler = x(3,:)*Rs;

figure(3);    clf;
plot(t, ue, t, ua_euler);
La = axis;   axis([0,Tfinal, La(3:4)*1.1]);
title('Anregung und Antwort des Filters (Euler-Verfahren)');
xlabel('Zeit in s');   grid on;

% -------- Antwort des Filters auf rechteckigem Signal
% ber ode-Funktionen
nord = 5;
x = zeros(nord,nt);
x0 = x(:,1);

my_options = odeset('RelTol', 1e-4, 'Refine',5);
%[tx,x] = ode23(@ableit,[0, Tfinal], x0);   
[tx,x] = ode45(@ableit,[0, Tfinal], x0, my_options);
uax = x(:,3)*Rs;

figure(4);    clf;
plot(t, ue)
hold on;
plot(tx, uax);
hold off;
La = axis;   axis([0,Tfinal, La(3:4)*1.1]);
title('Anregung und Antwort des Filters (ode-Funktion)');
xlabel('Zeit in s');   grid on;

% ------ Alle Signale zusammen
figure(5);    clf;
plot(t,ue, t, ua, t,ua_euler, tx, uax);
La = axis;   axis([0,Tfinal, La(3:4)*1.1]);
title('Anregung und Antwort des Filters');
xlabel('Zeit in s');   grid on;
legend('ue', 'ua-lsim','ua-euler','ua-ode');
xlabel('Zeit in s');   grid on;

%--------------------
function abl_y = ableit(t, x)
global ampl fsig nord A B

abl_y = zeros(nord,1);
uet = ampl*sign(cos(2*pi*t*fsig));
abl_y = A*x + B*uet;



