% Skript ellipt_3.m in dem ein passives elliptisches TP-Filter 
% aus ''Design of Analog Filters'' Rolf Schauman, Mac E. Van
% Valkenburg Seit 340 untersucht wird. 

clear;
% ------- Parameter der Schaltung
% Normierte Parameter
Rg = 1;            Rs = 1;
L1 = 0.5822;       L2 = 1.3629;
L3 = 0.5794;

L12 = 0.0032;      L23 = 0.0085;
C1 = 1.1658;       C2 = 1.1569;

f3dB = 1e6;
omega_3dB = 2*pi*f3dB;
Rg = 100;       Rs = Rg;

Lr = Rg/omega_3dB;      % Faktoren fr die absoluten
Cr = 1/(Rg*omega_3dB);  % Komponenten

% ------- Absolute Werte der Komponenten 
L1 = L1*Lr;       L2 = L2*Lr;
L3 = L3*Lr;

C1 = C1*Cr;       C2 = C2*Cr;
L12 = L12*Lr;     L23 = L23*Lr;

% Frequenzbereich
fc = f3dB; 
a1 = round(log10(fc/100)); 
a2 = round(log10(fc*100)); 
f = logspace(a1, a2, 1000);  % Logarithmische Frequenzschritte
omega = 2*pi*f;

% -------- Komplexer Frequenzgang
Ys = 1/Rs;    Z3 = j*omega*L3;
Y23 = 1./(j*omega*L23 + 1./(j*omega*C2));    
Z2 = j*omega*L2;
Y12 = 1./(j*omega*L12 + 1./(j*omega*C1)); 
Z1 = j*omega*L1 + Rg;

Ua = 1;
U2 = Ua*(Ys.*Z3) + Ua;
U1 = (U2.*Y23 + (U2-Ua)./Z3).*Z2 + U2;
Ug = (U1.*Y12 + (U1-U2)./Z2).*Z1 + U1;

H = Ua./Ug;
% -------- Darstellung des korrekten Frequenzgangs
figure(1);    clf;
subplot(211), semilogx(f, 20*log10(abs(H)));
title('Amplitudengang des elliptischen TP-Filters');
xlabel('Hz'); grid on;
subplot(212), semilogx(f, angle(H));
title('Phasengang des elliptischen TP-Filters');
xlabel('Hz'); grid on;

% ------- Bestimmung der Uebertragungsfunktion
[b,a] = invfreqs(H, omega, 6, 7, [], 30);  % Identifikation aus dem
% Frequenzgang

% -------- Darstellung des Frequenzgangs des
% identifizierten Systems
Hg = freqs(b,a,omega);
figure(2);    clf;
subplot(211), semilogx(f, 20*log10(abs(Hg)));
title('Amplitudengang des identifizierten TP-Filters');
xlabel('Hz'); grid on;
subplot(212), semilogx(f, angle(Hg));
title('Phasengang des identifizierten TP-Filters');
xlabel('Hz'); grid on;% ------- Sprungantwort

% ------- Sprungantwort des identifizierten Filters
figure(3);    clf;
my_sys = tf(b,a);
step(my_sys);
