% Skript ellipt_1.m in dem ein passives TP-Filter 
% untersucht wird

clear;
% ------- Parameter der Schaltung
Rg = 1;            Rs = 1;
L1 = 0.5822;       L2 = 1.3629;
L3 = 0.5794;

L12 = 0.0032;      L23 = 0.0085;
C1 = 1.1658;       C2 = 1.1569;

% ------- Frequenzgang
f = logspace(-2,2,1000);
omega = 2*pi*f;

Ys = 1/Rs;    Z3 = j*omega*L3;
Y23 = 1./(j*omega*L23 + 1./(j*omega*C2));    
Z2 = j*omega*L2;
Y12 = 1./(j*omega*L12 + 1./(j*omega*C1)); 
Z1 = j*omega*L1 + Rg;

Ua = 1;
U2 = Ua*(Ys.*Z3) + Ua;
U1 = (U2.*Y23 + (U2-Ua)./Z3).*Z2 + U2;
Ug = (U1.*Y12 + (U1-U2)./Z2).*Z1 + U1;

H = Ua./Ug;

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(abs(H)));
grid on;
subplot(212), semilogx(f, angle(H));
grid on;

% ------- bertragungsfunktion
[b,a] = invfreqs(H, omega, 7, 7)

figure(2);    clf;
Hg = freqs(b,a,omega);
subplot(211), semilogx(f, 20*log10(abs(Hg)));
grid on;

subplot(212), semilogx(f, angle(Hg));
grid on;

% ------- Sprungantwort
figure(3);    clf;
step(b,a);
