% Skript ellipt_1.m in dem ein passives TP-Filter 
% untersucht wird

clear;
% ------- Parameter der Schaltung
Rg = 1;            Rs = 1;
L1 = 0.5822;       L2 = 1.3629;
L3 = 0.5794;

L12 = 0.0032;      L23 = 0.0085;
C1 = 1.1658;       C2 = 1.1569;

% ------- Frequenzgang
f = logspace(-2,2,1000);
omega = 2*pi*f;

Ua = 1;
U2 = Ua*(1 + j*omega*L3/Rs);
U1 = U2.*(1 + (j*omega*L2)./(j*omega*L23 + 1./(j*omega*C2))) + Ua*j*omega*L2/Rs;
Ug = U1.*(1 + (j*omega*L1+Rg).*(1./(j*omega*L2) + 1./(j*omega*L12 + 1./(j*omega*C1))))...
    - U2.*(j*omega*L1+Rg)./(j*omega*L2);

H = Ua./Ug;

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(abs(H)));

subplot(212), semilogx(f, angle(H));

% ------- bertragungsfunktion
[b,a] = invfreqs(H, omega, 7, 7)

figure(2);    clf;
Hg = freqs(b,a,omega);
subplot(211), semilogx(f, 20*log10(abs(Hg)));

subplot(212), semilogx(f, angle(Hg));

% ------- Sprungantwort
figure(3);    clf;
step(b,a);
