% Skript butterw_passiv2.m in dem ein passives
% HP Butterworth-Filter nach den Tabellen von
% Zverev fr TP-Filter berechnet wird

clear;
% ------- Parameter des T-Filters
nord = 5;    % Ordnung des Filters 
Rg = 0.1e3;
Rs = Rg;
f_3dB = 10e6;
omega_3dB = 2*pi*f_3dB;

% Normierte Komponenten
C1 = 1/0.6180;
L2 = 1/1.6180;
C3 = 1/2;
L4 = 1/1.6180;
C5 = 1/0.6180;

% Referenz Induktivitt und Kapazitt
Lr = Rg/omega_3dB;
Cr = 1/(Rg*omega_3dB);

% Absolute Werte der Komponenten
C1 = C1*Cr;     C3 = C3*Cr;    C5 = C5*Cr; 
L2 = L2*Lr;     L4 = L4*Lr;

% ------- Komplexer Frequenzgang in logarithmischen Koordinaten
fc = f_3dB;
a1 = round(log10(fc/1000));
a2 = round(log10(fc*10));
f = logspace(a1, a2, 500);   % Logarithmische Frequenzschritte
% zwischen 10^a1 und 10^a2
omega = 2*pi*f;

% ------- bertragungsfunktion
Ua = 1;     % Ausgangsspannung
U4 = Ua./(j*omega*C5*Rg) + Ua;
U2 = (U4./(j*omega*L4)+(U4-Ua).*(j*omega*C5))./(j*omega*C3) + U4;
Ug = (U2./(j*omega*L2)+(U2-U4).*(j*omega*C3)).*(1./(j*omega*C1) + Rg) + U2;


H = Ua./Ug;
A = abs(H)/abs(H(end));         phi = angle(H);

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(A));
title('Amplitudengang mit logarithmischen Achsen ');
xlabel('Frequenz in Hz');    grid on;
La = axis;    ylabel('dB');
hold on;     
plot([fc, fc],[La(3), La(4)],'r');
hold off;

subplot(212), semilogx(f, unwrap(phi)*180/pi);
title('Phasengang mit logarithmischer Abszisse ');
xlabel('Frequenz in Hz');    grid on;    ylabel('Grad');
hold on;     La = axis;
plot([fc, fc],[La(3), La(4)],'r');
hold off;




