% Skript butterw_passiv1.m in dem ein passives
% TP Butterworth-Filter nach den Tabellen von
% Zverev berechnet wird

clear;
% ------- Parameter des T-Filters
nord = 5;    % Ordnung des Filters 
Rg = 1e3;
Rs = Rg;
f_3dB = 10e6;
omega_3dB = 2*pi*f_3dB;

% Normierte Komponenten
L1 = 0.6180;
C2 = 1.6180;
L3 = 2;
C4 = 1.6180;
L5 = 0.6180;

% Referenz Induktor und Kondensator
Lr = Rg/omega_3dB;
Cr = 1/(Rg*omega_3dB);

% Absolute Werte der Komponenten
L1 = L1*Lr;
C2 = C2*Cr;
L3 = L3*Lr;
C4 = C4*Cr;
L5 = L5*Lr;

% ------- Komplexer Frequenzgang in logarithmischen Koordinaten
fc = f_3dB;
a1 = round(log10(fc/100));
a2 = round(log10(fc*100));
f = logspace(a1, a2, 500);   % Logarithmische Frequenzschritte
% zwischen 10^a1 und 10^a2
omega = 2*pi*f;

Ua = 1;     % Ausgangsspannung
U4 = Ua*j*omega*L5/Rg + Ua;
U2 = (U4.*(j*omega*C4)+(U4-Ua)./(j*omega*L5)).*(j*omega*L3) + U4;
Ug = (U2.*(j*omega*C2)+(U2-U4)./(j*omega*L3)).*(j*omega*L1 + Rg) + U2;

H = Ua./Ug;
A = abs(H)/abs(H(1));     phi = angle(H);

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(A));
title('Amplitudengang mit logarithmischen Achsen ');
xlabel('Frequenz in Hz');    grid on;
La = axis;    ylabel('dB');
hold on;     
plot([fc, fc],[La(3), La(4)],'r');
hold off;

subplot(212), semilogx(f, unwrap(phi)*180/pi);
title('Phasengang mit logarithmischer Abszisse ');
xlabel('Frequenz in Hz');    grid on;    ylabel('Grad');
hold on;     La = axis;
plot([fc, fc],[La(3), La(4)],'r');
hold off;




