% Skript bandpass_passiv1.m in dem ein
% passives Bandpassfilter 10. Ordnung
% berechnet wird

clear;
% ------- Parameter des T-Filters
nord = 5;    % Ordnung des Filters 
Rg = 1e3;
Rs = Rg;
f_0 = 10e6;  % Mittefrequenz
omega_0 = 2*pi*f_0;

% Normierte Komponenten
alpha = 10
C1 = alpha;    L1 = 1/alpha;
C3 = C1;       L3 = L1;
C4 = C1;       C5 = C4;
L4 = L1;       L5 = L1;
betha = 0.1;
C2 = betha;      L2 = 1/betha;

% Referenz Induktor und Kondensator
Lr = Rg/omega_0;
Cr = 1/(Rg*omega_0);

% Absolute Werte der Komponenten
L1 = L1*Lr;    C1 = C1*Cr;
L2 = L2*Lr;    C2 = C2*Cr;
L3 = L3*Lr;    C3 = C3*Cr;
L4 = L4*Lr;    C4 = C4*Cr;
L5 = L5*Lr;    C5 = C5*Cr;

% ------- Komplexer Frequenzgang in logarithmischen Koordinaten
fc = f_0;
a1 = round(log10(fc/10));
a2 = round(log10(fc*10));
f = logspace(a1, a2, 1000);   % Logarithmische Frequenzschritte
% zwischen 10^a1 und 10^a2
omega = 2*pi*f;

% ------ Impedanzen und Admittanzen
Z1 = Rg + 1./(j*omega*C1) + j*omega*L1;
Z2 = 1./(j*omega*C2) + j*omega*L2;
Z3 = 1./(j*omega*C3) + j*omega*L3;
Y4 = j*omega*C4 + 1./(j*omega*L4);
Y5 = j*omega*C5 + 1./(j*omega*L5);
Y6 = 1/Rs;

Ua = 1;     % Ausgangsspannung
U2 = Ua*Y6.*Z3 + Ua;
U1 = (U2.*Y5 + (U2-Ua)./Z3).*Z2 + Ua;
Ug = (U1.*Y4 + (U1-U2)./Z2).*Z1 + U1;

H = Ua./Ug;
A = abs(H);     phi = angle(H);

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(A));
title('Amplitudengang mit logarithmischen Achsen ');
xlabel('Frequenz in Hz');    grid on;
La = axis;    ylabel('dB');
hold on;     
plot([fc, fc],[La(3), La(4)],'r');
hold off;

subplot(212), semilogx(f, unwrap(phi)*180/pi);
title('Phasengang mit logarithmischer Abszisse ');
xlabel('Frequenz in Hz');    grid on;    ylabel('Grad');
hold on;     La = axis;
plot([fc, fc],[La(3), La(4)],'r');
hold off;

%##########################
% -------- Frequenzgang mit linearen Koordinaten
fc = f_0;
f = linspace(0, 2*f_0, 500);
omega = 2*pi*f;

% ------ Impedanzen und Admittanzen
Z1 = Rg + 1./(j*omega*C1) + j*omega*L1;
Z2 = 1./(j*omega*C2) + j*omega*L2;
Z3 = 1./(j*omega*C3) + j*omega*L3;
Y4 = j*omega*C4 + 1./(j*omega*L4);
Y5 = j*omega*C5 + 1./(j*omega*L5);
Y6 = 1/Rs;

Ua = 1;     % Ausgangsspannung
U2 = Ua*Y6.*Z3 + Ua;
U1 = (U2.*Y5 + (U2-Ua)./Z3).*Z2 + Ua;
Ug = (U1.*Y4 + (U1-U2)./Z2).*Z1 + U1;

H = Ua./Ug;
A = abs(H);     phi = angle(H);


figure(2);    clf;
subplot(211), plot(f, A);
title('Amplitudengang mit linearen Achsen ');
xlabel('Frequenz in Hz');    grid on;
axis tight;
La = axis;    
hold on;     
plot([fc, fc],[La(3), La(4)],'r');
hold off;

subplot(212), plot(f, unwrap(phi)*180/pi);
title('Phasengang mit lineren Achsen ');
xlabel('Frequenz in Hz');    grid on;    ylabel('Grad');
hold on;     La = axis;
plot([fc, fc],[La(3), La(4)],'r');
hold off;
