% Skript aktiv_chebyHP3.m in dem ein Hochpassfilter vom
% Typ Tschebyschev im Zeitbereich untersucht wird
% Es wird die Sprungantwort ermittelt und dargestellt

clear;

% -------- Spezifikationen des Filters
fp = 10e3;    % Durchlassfrequenz
Rp = 1;       % Welligkeit im Durchlassbereich
nord = 3;     % Ordnung des Filters

% -------- Filter entwerfen mit Koeffizienten aus Tabelle
f01_r = 2;  % Charakteristische Frequenz (Relativ zur Durchlassfrequenz)
f02_r = 1;  % Charakteristische Frequenz (Relativ zur Durchlassfrequenz)
d = 0.5;    % Dmpfungsfaktor

f01 = fp*f01_r;      f02 = fp*f02_r;    % Absolute charakt. Frequenzen
% -------- Parameter der Schaltung
C1 = 1e-9;
R1 = 1/(2*pi*f01*C1);

C2 = 0.1e-9;    C3 = C2;
R2 = d/(2*pi*f02*C2);
R3 = 1/((2*pi*f02)^2*R2*C2*C3);

% ------- Matrizen des Systems
A = [-1/(R1*C1), 0 0; 0 0 1/(R2*C2);
    [-1 -1 -1]/(R3*C3)];
B = [1/(R1*C1); 0; 1/(R3*C3)];

% ------- Numerische Integration mit Euler-Verfahren
dt = 1e-7;
Tfinal = 5e-4;
t = 0:dt:Tfinal;
nt = length(t);

x = zeros(3, nt);   % Zustandsvariablen (Spannungen der 
                    % Kapazitten
ue = ones(1, nt);   % Eingangssprung
x(:,1) = zeros(3,1);% Anfangsspannungen der Kapazitten
ua = zeros(1,nt);   % Initialisiserung der Ausgangsspannung
ua(1) = -sum(x(:,1)) + ue(1);% Anfangswert der Ausgangsspannung

% Euler-Verfahren
for k = 1:nt-1
    x(1,k+1) = x(1,k) + dt*(-x(1,k) + ue(k))/(R1*C1);
    x(2,k+1) = x(2,k) + dt*x(3,k)/(R2*C2);
    x(3,k+1) = x(3,k) + dt*(-x(1,k) - x(2,k) - x(3,k) + ue(k))/(R3*C3);    
    ua(k+1) = -sum(x(:,k+1)) + ue(k+1);
end;

% Euler-Verfahren in Matrixform
%for k = 1:nt-1
%    x(:,k+1) = x(:,k) + dt*(A*x(:,k) + B*ue(k));
%    ua(k+1) = -sum(x(:,k+1)) + ue(k+1);
%end;

figure(1);   clf;
subplot(211), plot(t, x')
title('Sprungantwort der Zustandsvariablen (der Spannungen der Kapazitaeten)')
xlabel('Zeit in s');  grid on;
legend('uc1', 'uc2', 'uc3');

subplot(212), plot(t, ua);
title('Sprungantwort des Hochpassfilters (mit Euler-Verfahren und mit step-Funktion)')
xlabel('Zeit in s');  grid on;
hold on;

% -------- Sprungantwort mit step
% Filter entwerfen mit der Funktion cheby1
[b,a] = cheby1(nord, Rp, 2*pi*fp,'high','s');

my_sys = tf(b,a)
h = step(my_sys, t);
plot(t,h,'r');
hold off;





