% Skript aktiv_chebyHP2.m in dem ein Hochpassfilter vom
% Typ Tschebyschev im Zeitbereich untersucht wird

clear;

% -------- Spezifikationen des Filters
fp = 10e3;    % Durchlassfrequenz
Rp = 1;       % Welligkeit im Durchlassbereich
nord = 3;     % Ordnung des Filters

% -------- Filter entwerfen mit der Funktion cheby1
[b,a] = cheby1(nord, Rp, 2*pi*fp,'high','s');

% -------- Frequenzgang mit bode
a1 = round(log10(fp/100));    % fmin = 2 Dekade kleiner als fp
a2 = round(log10(fp*100));    % fmax = 2 Dekade grer als fp
f = logspace(a1, a2, 500);    % 500 Frequenzwerte 

[A, phi] = bode(b,a, 2*pi*f);

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(A));
title('Amplitudengang');
xlabel('Hz');    grid on;

subplot(212), semilogx(f, phi);
title('Phasengang in Grad');
xlabel('Hz');    grid on;

% -------- Sprungantwort mit step
my_sys = tf(b,a)
[h, t] = step(my_sys);

figure(2);   clf;
plot(t,h);
title('Sprungantwort')
xlabel('Zeit in s');   grid on;





