% Skript aktiv_chebyHP1.m in dem ein Hochpassfilter vom
% Typ Tschebyschev ermittelt wird

clear;

% -------- Spezifikationen des Filters
fp = 10e3;    % Durchlassfrequenz
Rp = 1;       % Welligkeit im Durchlassbereich
nord = 3;     % Ordnung des Filters

% -------- Filter entwerfen mit der Funktion cheby1
[b,a] = cheby1(nord, Rp, 2*pi*fp,'high','s');

% -------- Frequenzgang mit bode
a1 = round(log10(fp/100));    % fmin = 2 Dekade kleiner als fp
a2 = round(log10(fp*100));    % fmax = 2 Dekade grer als fp
f = logspace(a1, a2, 500);    % 500 Frequenzwerte 

[A, phi] = bode(b,a, 2*pi*f);

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(A));
title('Amplitudengang');
xlabel('Hz');    grid on;

subplot(212), semilogx(f, phi);
title('Phasengang in Grad');
xlabel('Hz');    grid on;

% -------- Frequenzgang direkt mit Hilfe der Polynome
zaehler = polyval(b, j*2*pi*f);  % Werte des Zhlerpolynoms
nenner = polyval(a, j*2*pi*f);   % Werte des Nennerpolynoms 

H = zaehler./nenner;             % bertragungsfunktion
A1 = abs(H);                     % Betrag (Amplitudengang)
phi1 = unwrap(angle(H))*180/pi;  % Phasengang

figure(2);    clf;
subplot(211), semilogx(f, 20*log10(A1));
title('Amplitudengang');
xlabel('Hz');    grid on;

subplot(212), semilogx(f, phi1);
title('Phasengang in Grad');
xlabel('Hz');    grid on;



