% Skript aktiv_butterTP3.m in dem ein Tiefpassfilter vom
% Typ Butterworth im Zeitbereich untersucht wird
% Es wird die Sprungantwort ermittelt

clear;

% -------- Spezifikationen des Filters
fp = 10e3;    % Durchlassfrequenz
nord = 3;     % Ordnung des Filters

% -------- Filter entwerfen mit Koeffizienten aus Tabelle
f01_r = 1;  % Charakteristische Frequenz (Relativ zur Durchlassfrequenz)
f02_r = 1;  % Charakteristische Frequenz (Relativ zur Durchlassfrequenz)
d = 1;      % Dmpfungsfaktor

f01 = fp*f01_r;      f02 = fp*f02_r;    % Absolute charakt. Frequenzen
% -------- Parameter der Schaltung
C1 = 1e-9;
R1 = 1/(2*pi*f01*C1);

C2 = 0.1e-9;    C3 = C2;
R3 = d/(2*pi*f02*C3);
R2 = 1/(((2*pi*f02)^2)*R3*C2*C3);

% ------- Matrizen des Systems
A = [[-1, 0, 0]/(R1*C1); [1, -1, -1]/(R2*C2);
    [0 1 0]/(R3*C3)];
B = [1/(R1*C1); 0; 0];

% ------- Numerische Integration mit Euler-Verfahren
dt = 1e-8;
Tfinal = 3e-4;
t = 0:dt:Tfinal;
nt = length(t);

ue = ones(1, nt);   % Eingangssprung
x = zeros(3, nt);   % Zustandsvariablen (Spannungen der 
                    % Kapazitten
x(:,1) = zeros(3,1);% Anfangsspannungen der Kapazitten

% Euler-Verfahren in Matrixform
for k = 1:nt-1
    x(:,k+1) = x(:,k) + dt*(A*x(:,k) + B*ue(k));
end;
ua = x(3,:);

figure(1);   clf;
plot(t, x')
title('Sprungantworten der Zustandsvariablen (der Spannungen der Kapazitaeten)')
xlabel('Zeit in s');  grid on;
legend('uc1', 'uc2', 'uc3');







