% Skript aktiv_butterTP2.m in dem ein Tiefpassfilter vom
% Typ Butterworth 3. Ordnung ermittelt und untersucht wird

clear;

% -------- Spezifikationen des Filters
fp = 10e3;    % Durchlassfrequenz
nord = 3;     % Ordnung des Filters
% Butterworth Filter
f0 = fp;
omega_0 = 2*pi*f0;
d = 1;

% -------- Koeffizienten der Polynome im Zhler und Nenner
b = 1;
a = [1/((omega_0)^3), 2/((omega_0)^2), 2/(omega_0), 1];

% -------- Frequenzgang mit bode
a1 = round(log10(fp/100));    % fmin = 2 Dekade kleiner als fp
a2 = round(log10(fp*100));    % fmax = 2 Dekade grer als fp
f = logspace(a1, a2, 500);    % 500 Frequenzwerte 

[A, phi] = bode(b,a, 2*pi*f);

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(A));
title('Amplitudengang');
xlabel('Hz');    grid on;

subplot(212), semilogx(f, phi);
title('Phasengang in Grad');
xlabel('Hz');    grid on;

% -------- Frequenzgang direkt mit Hilfe der Polynome
zaehler = polyval(b, j*2*pi*f);  % Werte des Zhlerpolynoms
nenner = polyval(a, j*2*pi*f);   % Werte des Nennerpolynoms 

H = zaehler./nenner;             % bertragungsfunktion
A1 = abs(H);                     % Betrag (Amplitudengang)
phi1 = unwrap(angle(H))*180/pi;  % Phasengang

figure(2);    clf;
subplot(211), semilogx(f, 20*log10(A1));
title('Amplitudengang');
xlabel('Hz');    grid on;

subplot(212), semilogx(f, phi1);
title('Phasengang in Grad');
xlabel('Hz');    grid on;



