% Skript BS_filter4.m in dem ein BS-Filter vierter
% Ordnung untersucht wird

clear;

% ------- Frequenzgang mit normierter Frequenz
f0 = 10e6;
f = logspace(6,8,5000);
omega = 2*pi*f;
Rg = 1e4;
Rs = Rg;

C1 = 50e-12;
L1 = 1/((2*pi*f0)^2*C1);
C2 = C1;     L2 = L1;

Y2 = 1./(1./(j*omega*C2) + j*omega*L2) + 1/Rs;
Z1 = 1./(j*omega*C1 + 1./(j*omega*L1)) + Rg;

% Frequenzgang
H = 1./(Z1.*Y2 + 1);

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(abs(H)));
title('Amplitudengang');
xlabel('Hz');    grid on;
La = axis;

subplot(212), semilogx(f, unwrap(angle(H))*180/pi);
title('Phasengang');
xlabel('Hz');    grid on;



