% Skript BP_filter2_1.m in dem ein BP-Filter zweiter
% Ordnung untersucht wird

clear;

% ------- Frequenzgang mit normierter Frequenz
omega_r = logspace(-1, 1,1000);      % Relative Frequenz                  
f = omega_r;

d = [0.01, 0.05, 0.2, 1];   % Dmpfungsfaktoren
nd = length(d);     nf = length(f);

% Frequenzgnge 
H = zeros(nd, nf);  % In den Zeilen sind die Frequenzgnge
for k = 1:nd
    H(k,:) = polyval([d(k),0], j*omega_r)...
        ./polyval([1, d(k), 1], j*omega_r);
end;

figure(1);    clf;
semilogx(f, 20*log10(abs(H)'));
title(['Amplitudengaenge   fuer   d =   ', num2str(d)]);
xlabel('f/f0');    grid on;
La = axis;

hold on
semilogx(La(1:2), [-3, -3],'r');
hold off