% Skript zwei_rlc_parallel_2.m in dem der Frequenzgang
% zweier parallel Resonanzkreise ermittelt wird

clear;
% -------- Parameter der Schaltung
Rg = 10e3;
f0r = 5e6;

Lr = 12e-4
Cr = 1/(Lr*(2*pi*f0r)^2)

L1 = 0.02*Lr,     C1 = 1/(L1*(2*pi*f0r)^2)

L2 = L1;   C2 = C1;

% Resonanzfrequenz
fmin = f0r/100;      a1 = round(log10(fmin));
fmax = f0r*100;      a2 = fix(log10(fmax));

f = logspace(a1, a2, 5000);
omega = 2*pi*f;

Y2 = 1/Rg + 1./(j*omega*L2) + j*omega*C2;
Y1 = 1./(j*omega*L1) + j*omega*C1;
Z12 = j*omega*Lr + 1./(j*omega*Cr);
% ------- Komplexer Frequenzgang
U2 = 1;
U1 = U2*(Y2.*Z12) + U2;
Ug = (U1.*Y1 + U2.*Y2)*Rg + U1;

H = U2./Ug;

figure(1);
subplot(211), semilogx(f, abs(H));
title('Amplitudengang linear');
xlabel('Hz');   grid on;

subplot(212), semilogx(f, angle(H)*180/pi);
title('Phasengang in Grad');
xlabel('Hz');   grid on;

figure(2);
subplot(211), semilogx(f, 20*log10(abs(H)));
title('Amplitudengang in dB');
xlabel('Hz');   grid on;

subplot(212), semilogx(f, angle(H)*180/pi);
title('Phasengang in Grad');
xlabel('Hz');   grid on;
