% Skript zwei_rlc_parallel.m in dem der Frequenzgang
% zweier parallel Resonanzkreise ermittelt wird

clear;
% -------- Parameter der Schaltung
Rg = 10e3;
Rs = 8e3;
R1 = 1000e3;         R2 = R1;
R12 = 10e3;
C1 = 100e-12;        C2 = C1*1.3;
L1 = 20e-6/1.3;      L2 = L1;

% Resonanzfrequenz
f0r = 1/(2*pi*sqrt(L1*C1));
fmin = f0r/100;  a1 = round(log10(fmin));
fmax = f0r*100;  a2 = fix(log10(fmax));

f = logspace(a1, a2, 1000);
omega = 2*pi*f;

Y2 = 1/R2 + 1/Rs + 1./(j*omega*L2) + j*omega*C2;
Y1 = 1/R1 + 1./(j*omega*L1) + j*omega*C1;

% ------- Komplexer Frequenzgang
U2 = 1;
U1 = U2*Y2*R12 + U2;
Ug = (U1.*Y1 + U2.*Y2)*Rg + U1;

H = U2./Ug; 

figure(1);
subplot(211), semilogx(f, abs(H));
title('Amplitudengang linear');
xlabel('Hz');   grid on;

subplot(212), semilogx(f, angle(H)*180/pi);
title('Phasengang in Grad');
xlabel('Hz');   grid on;


figure(2);
subplot(211), semilogx(f, 20*log10(abs(H)));
title('Amplitudengang in dB');
xlabel('Hz');   grid on;

subplot(212), semilogx(f, angle(H)*180/pi);
title('Phasengang in Grad');
xlabel('Hz');   grid on;
