% Skript zwei_generatoren1.m in dem ein Netzwerk
% mit zwei Generatoren untersucht wird
clear;
% ------- Parameter des Netzwerkes
Zg1 = 1;                     Zg2 = 1;
Z1 = 10*exp(j*pi/3);         Z2 = 10*exp(j*pi/3);
Z12 = 1*exp(j*pi/10);
Ug1 = 200*exp(j*0);
% ------- Berechnung der Strme
phi2 = -pi/10:pi/500:pi/10;   % Phasenlage Ug2 relativ zu Ug1
nphi = length(phi2);

A = [Zg1 0 Z1 0 0; 0 Zg2 0 Z2 0; 0 0 Z1 -Z2 -Z12;...
    -1 0 1 0 1; 0 1 0 -1 1];
Ai = inv(A);
B = [1 0; 0 1; 0 0; 0 0; 0 0 ];
AiB = Ai*B;
I = zeros(5, nphi); 
% I(1,:) = Ig1; I(2,:) = Ig2
% I(3,:) = I1;  I(4,:) = I2;  I(5,:) = I12
Ug2 = zeros(1, nphi);     % Initialisierung
for k = 1:nphi
    Ug2(k) = 200*exp(j*phi2(k));
    I(:,k) = AiB*[Ug1; Ug2(k)];
end; 
% ------- Wirkleistungen am Ausgang der Netze
P_A = abs(I(3,:).*Z1).*abs(I(5,:)).*cos(angle(I(3,:).*Z1)-angle(I(5,:)));
P_B = abs(I(4,:).*Z2).*abs(I(5,:)).*cos(angle(I(4,:).*Z2)-angle(-I(5,:)));
% ------- Wirkleistung an der Impedanz Z12
P12 = abs(I(3,:).*Z1 - I(4,:).*Z2).*abs(I(5,:)).*...
    cos(angle(I(3,:).*Z1 - I(4,:).*Z2) - angle(I(5,:)));
% ------- Darstellungen
phi2 = phi2*180/pi;
figure(1);    clf;
subplot(211), plot(phi2, P12);
   title(['Wirkleistung auf Z12  (Z12 = ', num2str(Z12),'  Ohm)']);
   xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
   ylabel('Watt');
subplot(223), plot(phi2, P_A);
   title('Wirkleistung am Ausgang Netz 1');
   xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
   ylabel('Watt');
subplot(224), plot(phi2, P_B);
   title('Wirkleistung am Ausgang Netz 2');
   xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
   ylabel('Watt');

return

figure(2);    clf;
subplot(221), plot(phi2, abs(I(1,:)))
title('Betrag des Stroms Ig1');
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('A')
subplot(223), plot(phi2, angle(I(1,:))*180/pi)
title('Winkel des Stroms Ig1');
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('Grad');
subplot(222), plot(phi2, abs(I(2,:)))
title('Betrag des Stroms Ig2');
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('A')
subplot(224), plot(phi2, angle(I(2,:))*180/pi)
title('Winkel des Stroms Ig2');
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('Grad');

figure(3);    clf;
subplot(221), plot(phi2, abs(I(3,:)))
title('Betrag des Stroms I1');
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('A')
subplot(223), plot(phi2, angle(I(3,:))*180/pi)
title('Winkel des Stroms I1');
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('Grad');
subplot(222), plot(phi2, abs(I(4,:)))
title('Betrag des Stroms I2');
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('A')
subplot(224), plot(phi2, angle(I(4,:))*180/pi)
title('Winkel des Stroms I2');
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('Grad');
% -------- Wirkleistungen
P12 = abs(I(3,:).*Z1 - I(4,:).*Z2).*abs(I(5,:)).*...
    cos(angle(I(3,:).*Z1 - I(4,:).*Z2) - angle(I(5,:)));
Pg1 = abs(Ug1).*abs(I(1,:)).*cos(angle(Ug1)-angle(I(1,:)));
Pg2 = abs(Ug2).*abs(I(2,:)).*cos(angle(Ug2)-angle(I(2,:)));

figure(4);    clf;
subplot(211), plot(phi2, P12);
title(['Wirkleistung auf Z12  (Z12 = ', num2str(Z12),'  Ohm)']);
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('Watt');
subplot(223), plot(phi2, Pg1);
title('Wirkleistung Generator 1');
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('Watt');
subplot(224), plot(phi2, Pg2);
title('Wirkleistung Generator 2');
xlabel('Winkel der Spannung Ug2 (Grad)');  grid on
ylabel('Watt');

