% Skript schalt_kond3.m in dem die Vorgngen bei 
% Zuschalten des Kompensationskondensators
% untersucht wird

clear;
% -------- Parameter des Systems
f = 50;          % 50 Hz
omega = 2*pi*f;
ug_ampl = 100;
phi = -pi/2;       % Einschalten bei ug = 0

R = 10;    L = 0.05;
C = L/(R^2 + (omega*L)^2)  % Kompensationskapazitaet
Rg = 1;

% -------- Numerische Lsung
dt = 0.0001;
Tfinal = 0.2;
Tschalt = 0.086;     % Einschalten am Scheitelpunkt 
%Tschalt = 0.1;       % Einschalten am Nulldurchgang

t = 0:dt:Tfinal;
nt = length(t);

ug = ug_ampl*cos(omega*t + phi);   % Anregung

uc = zeros(1,nt);
iL = zeros(1,nt);
ig = iL;

iL0 = 1;         uc0 = 0;
uc(1) = uc0;     iL(1) = iL0;
ig(1) = iL(1);

for k = 1:nt-1
    uc(k+1) = uc(k) + ( dt*((-uc(k)+ug(k))/Rg - iL(k))/C )*(t(k) >= Tschalt);
    iL(k+1) = iL(k) + (dt*(uc(k) - R*iL(k))/L)*(t(k) >= Tschalt) + ...
        (dt*(-(R+Rg)*iL(k) + ug(k))/L)*(t(k) < Tschalt);
    ig(k+1) = ((ug(k) - uc(k))/Rg)*(t(k) >= Tschalt) + iL(k)*(t(k) < Tschalt);
end;

uR = iL*R;

figure(1);
subplot(211), plot(t, ug, t, uc, t, uR);
title('Spannung  ug,  uc,  uR')
xlabel('Zeit in s');    grid on;

subplot(212), plot(t, ig*10, t, ug);
title('Strom  ig*10,  Spannung  ug')
xlabel('Zeit in s');    grid on;


    
    