% Skript schalt_kond2.m in dem die Vorgnge bei 
% Zuschalten der Kompensationskondensatoren
% untersucht wird

clear;
% -------- Parameter des Systems
f = 50;          % 50 Hz
omega = 2*pi*f;
ug_ampl = 100;
phi = -pi/2;       % Einschalten bei ug = 0
%phi = -0;         % Einschalten bei ug = ug_ampl !!!

R = 10;    L = 0.05;
Rc = 1;
Rg = 0.1;

% -------- Kompensationskapazitt
%C = linspace(1e-4, 3e-4, 100);
%ac = omega*L*(Rc^2 + (1./(omega*C)).^2);
%bc = (R^2+(omega*L)^2)./(omega*C);

C = 1.445e-4;
C = L/(R^2 + (omega*L)^2)  % Kompensationskapazitaet

% -------- Numerische Lsung
dt = 0.0001;
Tfinal = 0.1;
t = 0:dt:Tfinal;
nt = length(t);

ug = ug_ampl*cos(omega*t + phi);   % Anregung

uc = zeros(1,nt);
iL = zeros(1,nt);

iL0 = 0;         uc0 = 0;
uc(1) = uc0;     iL(1) = iL0;

for k = 1:nt-1
    uc(k+1) = uc(k) + dt*(-uc(k)+ug(k) - iL(k)*Rg)/(C*(Rg + Rc));
    iL(k+1) = iL(k) + dt*(uc(k) - R*iL(k) + ...
        Rc*(-uc(k)+ug(k) - iL(k)*Rg)/(Rg+Rc))/L;
end;
ic = (ug-uc-iL*Rg)/(Rg + Rc);
ig = iL + ic;
uR = iL*R;
us = uc + ic*Rc;  

figure(1);
subplot(211), plot(t, ug, t, uc, t, uR);
title('Spannungen ug, uc, uR');
xlabel('Zeit in s');    grid on;
legend('ug', 'uc', 'uR');

nd = 1:fix(nt/5);
subplot(223), plot(t(nd), ig(nd));
title('Strom ig beim Einschwingen');
xlabel('Zeit in s');    grid on;

nd = fix(nt/5):nt;
subplot(224), plot(t(nd), ig(nd), t(nd), us(nd)/10);
title('Strom ig und Spannung us/10 im stationaeren Zustand');
xlabel('Zeit in s');    grid on;
La = axis;   axis([t(nd(1)), La(2:4)])
    
    