% Skript schalt_kond1.m in dem die Vorgnge bei 
% Zuschalten der Kompensationskondensatoren
% untersucht wird

clear;
% -------- Parameter des Systems
f = 50;          % 50 Hz
omega = 2*pi*f;
ug_ampl = 100;
phi = -pi/2;       % Einschalten bei ug = 0
% phi = 0;         % Einschalten bei ug = ug_ampl !!!

R = 10;    L = 0.05;
C = L/(R^2 + (omega*L)^2)  % Kompensationskapazitaet
Rg = 1;

% -------- Numerische Lsung
dt = 0.0001;
Tfinal = 0.1;
t = 0:dt:Tfinal;
nt = length(t);

ug = ug_ampl*cos(omega*t + phi);   % Anregung

uc = zeros(1,nt);
iL = zeros(1,nt);

iL0 = 1;         uc0 = 0;
uc(1) = uc0;     iL(1) = iL0;

for k = 1:nt-1
    uc(k+1) = uc(k) + dt*((-uc(k)+ug(k))/Rg - iL(k))/C;
    iL(k+1) = iL(k) + dt*(uc(k) - R*iL(k))/L;
end;

ig = (ug - uc)/Rg;
uR = iL*R;

figure(1);
subplot(211), plot(t, ug, t, uc, t, uR);

nd = 1:fix(nt/10);
subplot(223), plot(t(nd), 10*ig(nd), t(nd), ug(nd));

nd = fix(nt/5):nt;
subplot(224), plot(t(nd), 10*ig(nd), t(nd), ug(nd));
axis tight
    
    